/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.mibble;

import java.util.HashMap;
import net.percederberg.grammatica.parser.Node;
import net.percederberg.grammatica.parser.Production;
import net.percederberg.grammatica.parser.Token;

class MibAnalyzerUtil {
    private static HashMap commentTokens = new HashMap();

    MibAnalyzerUtil() {
    }

    static boolean isBitValue(Node node) {
        if (node.getId() == 1004) {
            return true;
        }
        if (node.getId() == 2079 && node.getChildCount() < 4) {
            return true;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!MibAnalyzerUtil.isBitValue(node.getChildAt(i))) continue;
            return true;
        }
        return false;
    }

    static String getComments(Node node) {
        Token token;
        String comment = "";
        String str = MibAnalyzerUtil.getCommentsBefore(node);
        if (str != null) {
            comment = str;
        }
        if ((str = MibAnalyzerUtil.getCommentsInside(node)) != null) {
            if (comment.length() > 0) {
                comment = comment + "\n\n";
            }
            comment = comment + str;
        }
        if ((token = MibAnalyzerUtil.getCommentTokenSameLine(node)) != null) {
            if (comment.length() > 0) {
                comment = comment + "\n\n";
            }
            token = token.getPreviousToken();
            comment = comment + MibAnalyzerUtil.getCommentsAfter((Node)token);
        }
        return comment.length() <= 0 ? null : comment;
    }

    static String getCommentsFooter(Node node) {
        String comment = MibAnalyzerUtil.getCommentsAfter(node);
        commentTokens.clear();
        return comment;
    }

    private static String getCommentsBefore(Node node) {
        Token token = MibAnalyzerUtil.getFirstToken(node);
        String comment = "";
        if (token != null) {
            token = token.getPreviousToken();
        }
        while (token != null) {
            if (token.getId() == 1106) {
                comment = MibAnalyzerUtil.getLineBreaks(token.getImage()) + comment;
            } else {
                if (token.getId() != 1107 || commentTokens.containsKey(token)) break;
                commentTokens.put(token, null);
                comment = token.getImage().substring(2).trim() + comment;
            }
            token = token.getPreviousToken();
        }
        return (comment = comment.trim()).length() <= 0 ? null : comment;
    }

    private static String getCommentsAfter(Node node) {
        Token token = MibAnalyzerUtil.getLastToken(node);
        String comment = "";
        if (token != null) {
            token = token.getNextToken();
        }
        while (token != null) {
            if (token.getId() == 1106) {
                comment = comment + MibAnalyzerUtil.getLineBreaks(token.getImage());
            } else {
                if (token.getId() != 1107 || commentTokens.containsKey(token)) break;
                commentTokens.put(token, null);
                comment = comment + token.getImage().substring(2).trim();
            }
            token = token.getNextToken();
        }
        return (comment = comment.trim()).length() <= 0 ? null : comment;
    }

    private static String getCommentsInside(Node node) {
        Token last = MibAnalyzerUtil.getLastToken(node);
        String comment = "";
        for (Token token = MibAnalyzerUtil.getFirstToken(node); token != null && token != last; token = token.getNextToken()) {
            if (token.getId() != 1107 || commentTokens.containsKey(token)) continue;
            commentTokens.put(token, null);
            comment = comment + token.getImage().substring(2).trim() + "\n";
        }
        return (comment = comment.trim()).length() <= 0 ? null : comment;
    }

    private static Token getCommentTokenSameLine(Node node) {
        Token last = MibAnalyzerUtil.getLastToken(node);
        if (last == null) {
            return null;
        }
        block4: for (Token token = last.getNextToken(); token != null; token = token.getNextToken()) {
            switch (token.getId()) {
                case 1004: 
                case 1106: {
                    continue block4;
                }
                case 1107: {
                    if (last.getEndLine() == token.getStartLine()) {
                        return token;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static Token getFirstToken(Node node) {
        if (node instanceof Production) {
            return MibAnalyzerUtil.getFirstToken(node.getChildAt(0));
        }
        if (node instanceof Token) {
            return (Token)node;
        }
        return null;
    }

    private static Token getLastToken(Node node) {
        if (node instanceof Production) {
            return MibAnalyzerUtil.getLastToken(node.getChildAt(node.getChildCount() - 1));
        }
        if (node instanceof Token) {
            return (Token)node;
        }
        return null;
    }

    private static String getLineBreaks(String str) {
        StringBuffer res = new StringBuffer();
        if (str == null) {
            return null;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\n') continue;
            res.append('\n');
        }
        return res.toString();
    }
}

