/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMasterUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.ejb.CreateException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMibInfo {
    protected static Log m_log = LogFactory.getLog(AddMibInfo.class);
    protected static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    protected static final String TRAP_OBJECT_NAME = "jboss.j2ee:jndiName=SnmpTrapMaster,service=EJB";
    protected static final String MIB_OBJECT_NAME = "jboss.j2ee:jndiName=SnmpTrapMibMaster,service=EJB";
    protected static final String OPERATION_NAME = "flushCache";

    public void add(SnmpTrapMibMasterData mib, List<SnmpTrapMasterData> traps, String user) throws CreateException, NamingException {
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            SnmpTrapMibMasterUtil.getLocalHome().create(mib.getMib(), mib.getOrderNo(), mib.getDescription(), now, now, user, user);
            for (SnmpTrapMasterData trap : traps) {
                SnmpTrapMasterUtil.getLocalHome().create(trap.getMib(), trap.getTrapOid(), trap.getGenericId(), trap.getSpecificId(), trap.getUei(), trap.getPriority(), trap.getLogmsg(), trap.getDescr());
            }
            this.flushCache(MIB_OBJECT_NAME);
            this.flushCache(TRAP_OBJECT_NAME);
        }
        catch (CreateException e) {
            m_log.debug((Object)("add() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            m_log.debug((Object)("add() : " + e.getMessage()));
            throw e;
        }
    }

    public void flushCache(String objectName) {
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(objectName);
            server.invoke(name, OPERATION_NAME, null, null);
        }
        catch (NamingException e) {
            m_log.debug((Object)("flushCache() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            m_log.debug((Object)("flushCache() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            m_log.debug((Object)("flushCache() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            m_log.debug((Object)("flushCache() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            m_log.debug((Object)("flushCache() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            m_log.debug((Object)("flushCache() : " + e.getMessage()));
        }
        catch (IOException e) {
            m_log.debug((Object)("flushCache() : " + e.getMessage()));
        }
    }
}

