/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser.re;

import java.io.PrintWriter;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.re.CharBuffer;
import net.percederberg.grammatica.parser.re.Element;
import net.percederberg.grammatica.parser.re.Matcher;
import net.percederberg.grammatica.parser.re.StringElement;

class CharacterSetElement
extends Element {
    public static final CharacterSetElement DOT = new CharacterSetElement(false);
    public static final CharacterSetElement DIGIT = new CharacterSetElement(false);
    public static final CharacterSetElement NON_DIGIT = new CharacterSetElement(true);
    public static final CharacterSetElement WHITESPACE = new CharacterSetElement(false);
    public static final CharacterSetElement NON_WHITESPACE = new CharacterSetElement(true);
    public static final CharacterSetElement WORD = new CharacterSetElement(false);
    public static final CharacterSetElement NON_WORD = new CharacterSetElement(true);
    private boolean inverted;
    private ArrayList contents = new ArrayList();

    public CharacterSetElement(boolean bl) {
        this.inverted = bl;
    }

    public void addCharacter(char c) {
        this.contents.add(new Character(c));
    }

    public void addCharacters(String string) {
        int n = 0;
        while (n < string.length()) {
            this.addCharacter(string.charAt(n));
            ++n;
        }
    }

    public void addCharacters(StringElement stringElement) {
        this.addCharacters(stringElement.getString());
    }

    public void addRange(char c, char c2) {
        this.contents.add(new Range(c, c2));
    }

    public void addCharacterSet(CharacterSetElement characterSetElement) {
        this.contents.add(characterSetElement);
    }

    public Object clone() {
        return this;
    }

    public int match(Matcher matcher, CharBuffer charBuffer, int n, int n2) {
        if (n2 != 0) {
            return -1;
        }
        if (n >= charBuffer.length()) {
            matcher.setReadEndOfString();
            return -1;
        }
        char c = charBuffer.charAt(n);
        return this.inSet(c) ? 1 : -1;
    }

    private boolean inSet(char c) {
        if (this == DOT) {
            return this.inDotSet(c);
        }
        if (this == DIGIT || this == NON_DIGIT) {
            return this.inDigitSet(c) != this.inverted;
        }
        if (this == WHITESPACE || this == NON_WHITESPACE) {
            return this.inWhitespaceSet(c) != this.inverted;
        }
        if (this == WORD || this == NON_WORD) {
            return this.inWordSet(c) != this.inverted;
        }
        return this.inUserSet(c) != this.inverted;
    }

    private boolean inDotSet(char c) {
        switch (c) {
            case '\n': 
            case '\r': 
            case '\u0085': 
            case '\u2028': 
            case '\u2029': {
                return false;
            }
        }
        return true;
    }

    private boolean inDigitSet(char c) {
        return '0' <= c && c <= '9';
    }

    private boolean inWhitespaceSet(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private boolean inWordSet(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
    }

    private boolean inUserSet(char c) {
        int n = 0;
        while (n < this.contents.size()) {
            CharacterSetElement characterSetElement;
            Range range;
            Character c2;
            Object e = this.contents.get(n);
            if (e instanceof Character ? (c2 = (Character)e).charValue() == c : (e instanceof Range ? (range = (Range)e).inside(c) : e instanceof CharacterSetElement && (characterSetElement = (CharacterSetElement)e).inSet(c))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void printTo(PrintWriter printWriter, String string) {
        printWriter.println(string + this.toString());
    }

    public String toString() {
        if (this == DOT) {
            return ".";
        }
        if (this == DIGIT) {
            return "\\d";
        }
        if (this == NON_DIGIT) {
            return "\\D";
        }
        if (this == WHITESPACE) {
            return "\\s";
        }
        if (this == NON_WHITESPACE) {
            return "\\S";
        }
        if (this == WORD) {
            return "\\w";
        }
        if (this == NON_WORD) {
            return "\\W";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.inverted) {
            stringBuffer.append("^[");
        } else {
            stringBuffer.append("[");
        }
        int n = 0;
        while (n < this.contents.size()) {
            stringBuffer.append(this.contents.get(n));
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class Range {
        private char min;
        private char max;

        public Range(char c, char c2) {
            this.min = c;
            this.max = c2;
        }

        public boolean inside(char c) {
            return c >= this.min && c <= this.max;
        }

        public String toString() {
            return this.min + "-" + this.max;
        }
    }
}

