/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import net.percederberg.grammatica.parser.LookAheadSet;
import net.percederberg.grammatica.parser.Token;

public class ProductionPatternElement {
    private boolean token;
    private int id;
    private int min;
    private int max;
    private LookAheadSet lookAhead;

    public ProductionPatternElement(boolean bl, int n, int n2, int n3) {
        this.token = bl;
        this.id = n;
        if (n2 < 0) {
            n2 = 0;
        }
        this.min = n2;
        if (n3 <= 0) {
            n3 = Integer.MAX_VALUE;
        } else if (n3 < n2) {
            n3 = n2;
        }
        this.max = n3;
        this.lookAhead = null;
    }

    public boolean isToken() {
        return this.token;
    }

    public boolean isProduction() {
        return !this.token;
    }

    public boolean isMatch(Token token) {
        return this.isToken() && token != null && token.getId() == this.id;
    }

    public int getId() {
        return this.id;
    }

    public int getMinCount() {
        return this.min;
    }

    public int getMaxCount() {
        return this.max;
    }

    public boolean equals(Object object) {
        if (object instanceof ProductionPatternElement) {
            ProductionPatternElement productionPatternElement = (ProductionPatternElement)object;
            return this.token == productionPatternElement.token && this.id == productionPatternElement.id && this.min == productionPatternElement.min && this.max == productionPatternElement.max;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        if (this.token) {
            stringBuffer.append("(Token)");
        } else {
            stringBuffer.append("(Production)");
        }
        if (this.min != 1 || this.max != 1) {
            stringBuffer.append("{");
            stringBuffer.append(this.min);
            stringBuffer.append(",");
            stringBuffer.append(this.max);
            stringBuffer.append("}");
        }
        return stringBuffer.toString();
    }

    LookAheadSet getLookAhead() {
        return this.lookAhead;
    }

    void setLookAhead(LookAheadSet lookAheadSet) {
        this.lookAhead = lookAheadSet;
    }
}

