/*
 * Decompiled with CFR 0.152.
 */
package net.percederberg.grammatica.parser;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import net.percederberg.grammatica.parser.Parser;
import net.percederberg.grammatica.parser.Token;
import net.percederberg.grammatica.parser.Tokenizer;

class LookAheadSet {
    private ArrayList elements = new ArrayList();
    private int maxLength;

    public LookAheadSet(int n) {
        this.maxLength = n;
    }

    public LookAheadSet(int n, LookAheadSet lookAheadSet) {
        this(n);
        this.addAll(lookAheadSet);
    }

    public int size() {
        return this.elements.size();
    }

    public int getMinLength() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n2);
            if (n < 0 || sequence.length() < n) {
                n = sequence.length();
            }
            ++n2;
        }
        return n < 0 ? 0 : n;
    }

    public int getMaxLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n2);
            if (sequence.length() > n) {
                n = sequence.length();
            }
            ++n2;
        }
        return n;
    }

    public int[] getInitialTokens() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < this.elements.size()) {
            Integer n2 = ((Sequence)this.elements.get(n)).getToken(0);
            if (n2 != null && !arrayList.contains(n2)) {
                arrayList.add(n2);
            }
            ++n;
        }
        int[] nArray = new int[arrayList.size()];
        n = 0;
        while (n < arrayList.size()) {
            nArray[n] = (Integer)arrayList.get(n);
            ++n;
        }
        return nArray;
    }

    public boolean isRepetitive() {
        int n = 0;
        while (n < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n);
            if (sequence.isRepetitive()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isNext(Parser parser) {
        int n = 0;
        while (n < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n);
            if (sequence.isNext(parser)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isNext(Parser parser, int n) {
        int n2 = 0;
        while (n2 < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n2);
            if (sequence.isNext(parser, n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isOverlap(LookAheadSet lookAheadSet) {
        int n = 0;
        while (n < this.elements.size()) {
            if (lookAheadSet.isOverlap((Sequence)this.elements.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isOverlap(Sequence sequence) {
        int n = 0;
        while (n < this.elements.size()) {
            Sequence sequence2 = (Sequence)this.elements.get(n);
            if (sequence.startsWith(sequence2) || sequence2.startsWith(sequence)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean contains(Sequence sequence) {
        return this.findSequence(sequence) != null;
    }

    public boolean intersects(LookAheadSet lookAheadSet) {
        int n = 0;
        while (n < this.elements.size()) {
            if (lookAheadSet.contains((Sequence)this.elements.get(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Sequence findSequence(Sequence sequence) {
        int n = 0;
        while (n < this.elements.size()) {
            if (this.elements.get(n).equals(sequence)) {
                return (Sequence)this.elements.get(n);
            }
            ++n;
        }
        return null;
    }

    private void add(Sequence sequence) {
        if (sequence.length() > this.maxLength) {
            sequence = new Sequence(this.maxLength, sequence);
        }
        if (!this.contains(sequence)) {
            this.elements.add(sequence);
        }
    }

    public void add(int n) {
        this.add(new Sequence(false, n));
    }

    public void addAll(LookAheadSet lookAheadSet) {
        int n = 0;
        while (n < lookAheadSet.elements.size()) {
            this.add((Sequence)lookAheadSet.elements.get(n));
            ++n;
        }
    }

    public void addEmpty() {
        this.add(new Sequence());
    }

    private void remove(Sequence sequence) {
        ((AbstractCollection)this.elements).remove(sequence);
    }

    public void removeAll(LookAheadSet lookAheadSet) {
        int n = 0;
        while (n < lookAheadSet.elements.size()) {
            this.remove((Sequence)lookAheadSet.elements.get(n));
            ++n;
        }
    }

    public LookAheadSet createNextSet(int n) {
        LookAheadSet lookAheadSet = new LookAheadSet(this.maxLength - 1);
        int n2 = 0;
        while (n2 < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n2);
            Integer n3 = sequence.getToken(0);
            if (n3 != null && n3 == n) {
                lookAheadSet.add(sequence.subsequence(1));
            }
            ++n2;
        }
        return lookAheadSet;
    }

    public LookAheadSet createIntersection(LookAheadSet lookAheadSet) {
        LookAheadSet lookAheadSet2 = new LookAheadSet(this.maxLength);
        int n = 0;
        while (n < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n);
            Sequence sequence2 = lookAheadSet.findSequence(sequence);
            if (sequence2 != null && sequence.isRepetitive()) {
                lookAheadSet2.add(sequence2);
            } else if (sequence2 != null) {
                lookAheadSet2.add(sequence);
            }
            ++n;
        }
        return lookAheadSet2;
    }

    public LookAheadSet createCombination(LookAheadSet lookAheadSet) {
        LookAheadSet lookAheadSet2 = new LookAheadSet(this.maxLength);
        if (this.size() <= 0) {
            return lookAheadSet;
        }
        if (lookAheadSet.size() <= 0) {
            return this;
        }
        int n = 0;
        while (n < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n);
            if (sequence.length() >= this.maxLength) {
                lookAheadSet2.add(sequence);
            } else if (sequence.length() <= 0) {
                lookAheadSet2.addAll(lookAheadSet);
            } else {
                int n2 = 0;
                while (n2 < lookAheadSet.elements.size()) {
                    Sequence sequence2 = (Sequence)lookAheadSet.elements.get(n2);
                    lookAheadSet2.add(sequence.concat(this.maxLength, sequence2));
                    ++n2;
                }
            }
            ++n;
        }
        return lookAheadSet2;
    }

    public LookAheadSet createOverlaps(LookAheadSet lookAheadSet) {
        LookAheadSet lookAheadSet2 = new LookAheadSet(this.maxLength);
        int n = 0;
        while (n < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n);
            if (lookAheadSet.isOverlap(sequence)) {
                lookAheadSet2.add(sequence);
            }
            ++n;
        }
        return lookAheadSet2;
    }

    public LookAheadSet createFilter(LookAheadSet lookAheadSet) {
        LookAheadSet lookAheadSet2 = new LookAheadSet(this.maxLength);
        if (this.size() <= 0 || lookAheadSet.size() <= 0) {
            return this;
        }
        int n = 0;
        while (n < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n);
            int n2 = 0;
            while (n2 < lookAheadSet.elements.size()) {
                Sequence sequence2 = (Sequence)lookAheadSet.elements.get(n2);
                if (sequence.startsWith(sequence2)) {
                    lookAheadSet2.add(sequence.subsequence(sequence2.length()));
                }
                ++n2;
            }
            ++n;
        }
        return lookAheadSet2;
    }

    public LookAheadSet createRepetitive() {
        LookAheadSet lookAheadSet = new LookAheadSet(this.maxLength);
        int n = 0;
        while (n < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n);
            if (sequence.isRepetitive()) {
                lookAheadSet.add(sequence);
            } else {
                lookAheadSet.add(new Sequence(true, sequence));
            }
            ++n;
        }
        return lookAheadSet;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Tokenizer tokenizer) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < this.elements.size()) {
            Sequence sequence = (Sequence)this.elements.get(n);
            stringBuffer.append("\n  ");
            stringBuffer.append(sequence.toString(tokenizer));
            ++n;
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    private class Sequence {
        private boolean repeat = false;
        private ArrayList tokens = null;

        public Sequence() {
            this.repeat = false;
            this.tokens = new ArrayList(0);
        }

        public Sequence(boolean bl, int n) {
            this.repeat = false;
            this.tokens = new ArrayList(1);
            this.tokens.add(new Integer(n));
        }

        public Sequence(int n, Sequence sequence) {
            this.repeat = sequence.repeat;
            this.tokens = new ArrayList(n);
            if (sequence.length() < n) {
                n = sequence.length();
            }
            int n2 = 0;
            while (n2 < n) {
                this.tokens.add(sequence.tokens.get(n2));
                ++n2;
            }
        }

        public Sequence(boolean bl, Sequence sequence) {
            this.repeat = bl;
            this.tokens = sequence.tokens;
        }

        public int length() {
            return this.tokens.size();
        }

        public Integer getToken(int n) {
            if (n >= 0 && n < this.tokens.size()) {
                return (Integer)this.tokens.get(n);
            }
            return null;
        }

        public boolean equals(Object object) {
            if (object instanceof Sequence) {
                return ((AbstractList)this.tokens).equals(((Sequence)object).tokens);
            }
            return false;
        }

        public boolean startsWith(Sequence sequence) {
            if (this.length() < sequence.length()) {
                return false;
            }
            int n = 0;
            while (n < sequence.tokens.size()) {
                if (!this.tokens.get(n).equals(sequence.tokens.get(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public boolean isRepetitive() {
            return this.repeat;
        }

        public boolean isNext(Parser parser) {
            int n = 0;
            while (n < this.tokens.size()) {
                Integer n2 = (Integer)this.tokens.get(n);
                Token token = parser.peekToken(n);
                if (token == null || token.getId() != n2.intValue()) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public boolean isNext(Parser parser, int n) {
            if (n > this.tokens.size()) {
                n = this.tokens.size();
            }
            int n2 = 0;
            while (n2 < n) {
                Integer n3 = (Integer)this.tokens.get(n2);
                Token token = parser.peekToken(n2);
                if (token == null || token.getId() != n3.intValue()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(Tokenizer tokenizer) {
            StringBuffer stringBuffer = new StringBuffer();
            if (tokenizer == null) {
                stringBuffer.append(this.tokens.toString());
            } else {
                stringBuffer.append("[");
                int n = 0;
                while (n < this.tokens.size()) {
                    Integer n2 = (Integer)this.tokens.get(n);
                    String string = tokenizer.getPatternDescription(n2);
                    if (n > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(string);
                    ++n;
                }
                stringBuffer.append("]");
            }
            if (this.repeat) {
                stringBuffer.append(" *");
            }
            return stringBuffer.toString();
        }

        public Sequence concat(int n, Sequence sequence) {
            Sequence sequence2 = new Sequence(n, this);
            if (sequence.repeat) {
                sequence2.repeat = true;
            }
            if ((n -= this.length()) > sequence.length()) {
                sequence2.tokens.addAll(sequence.tokens);
            } else {
                int n2 = 0;
                while (n2 < n) {
                    sequence2.tokens.add(sequence.tokens.get(n2));
                    ++n2;
                }
            }
            return sequence2;
        }

        public Sequence subsequence(int n) {
            Sequence sequence = new Sequence(this.length(), this);
            while (n > 0 && sequence.tokens.size() > 0) {
                sequence.tokens.remove(0);
                --n;
            }
            return sequence;
        }
    }
}

