/*
 * Decompiled with CFR 0.152.
 */
package jp.hrtdotnet.java.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.hrtdotnet.java.io.HFile;
import jp.hrtdotnet.java.io.HWriter;

public class HFileWriter
extends HWriter {
    private HFile hFile = null;
    private boolean directoryFlg = false;
    private String alias = null;
    private int digit = 0;

    public HFileWriter(String filePath, boolean directoryFlg, String alias) throws IOException {
        this(new HFile(filePath), directoryFlg, alias);
    }

    public HFileWriter(HFile hFile, boolean directoryFlg, String alias) {
        this(hFile, directoryFlg, alias, -1);
    }

    public HFileWriter(String filePath, boolean directoryFlg, String alias, int digit) throws IOException {
        this(new HFile(filePath), directoryFlg, alias, digit);
    }

    public HFileWriter(HFile hFile, boolean directoryFlg, String alias, int digit) {
        if (hFile == null) {
            throw new NullPointerException("HFile-object is null.");
        }
        this.hFile = hFile;
        this.directoryFlg = directoryFlg;
        this.alias = alias;
        this.digit = digit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream is) throws IOException {
        this.makeOutputFile();
        if (this.directoryFlg) {
            this.makeDirectory();
        }
        FileOutputStream fos = new FileOutputStream(this.hFile);
        try {
            this.write(is, fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    protected void makeDirectory() {
        File directory = this.hFile.getParentFile();
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
    }

    protected void makeOutputFile() throws IOException {
        String outputFilePath = null;
        outputFilePath = this.digit <= -1 ? this.hFile.getOtherFileName(this.alias) : this.hFile.getOtherFileName(this.alias, this.digit);
        this.hFile = new HFile(outputFilePath);
    }
}

