/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: PhraseProperty.hpp 26 2011-05-10 12:09:48Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_SAPI_PHRASE_PROPETY_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_SAPI_PHRASE_PROPETY_HPP_

#include <sphelper.h>

#include <string>

namespace spcf {

	/**
	 * vpeBłB
	 */
	class PhraseProperty {
	private:
		std::string name_;
		bool hasVal_;
		long val_;
		bool hasValStr_;
		std::string valstr_;

	public:
		/**
		 * vpeB\z܂B
		 */
		PhraseProperty() : name_(""), hasVal_(false), hasValStr_(false) {
		}

		/**
		 * vpeB\z܂B
		 */
		PhraseProperty(const SPPHRASEPROPERTY* property);

		/**
		 * vpeB\z܂B
		 */
		PhraseProperty(const std::string& name) :
		name_(name), hasVal_(false), hasValStr_(false) {
		}

		/**
		 * vpeB\z܂B
		 */
		PhraseProperty(const std::string& name, long val) :
		name_(name), hasVal_(true), val_(val), hasValStr_(false) {
		}

		/**
		 * vpeB\z܂B
		 */
		PhraseProperty(const std::string& name, const std::string& valstr) :
		name_(name), hasVal_(false), hasValStr_(true), valstr_(valstr) {
		}

		/**
		 * vpeB\z܂B
		 */
		PhraseProperty(const std::string& name, long val, const std::string& valstr) :
		name_(name), hasVal_(true), val_(val), hasValStr_(true), valstr_(valstr) {
		}

	public:
		/**
		 * vpeBLǂ𔻒f܂B
		 */
		operator bool() const {
			return !name_.empty();
		}

		/**
		 * vpeBǂ𔻒f܂B
		 */
		bool operator!() const {
			return name_.empty();
		}

	public:
		/**
		 * O擾܂B
		 */
		const std::string& getName() const {
			return name_;
		}

		/**
		 * VALɂĒlw肳Ă邩ǂ𔻒f܂B
		 */
		bool hasVal() const {
			return hasVal_;
		}

		/**
		 * VALɂĎw肵l擾܂B
		 */
		long getVal() const {
			return val_;
		}

		/**
		 * VALSTRɂĕ񂪎w肳Ă邩ǂ𔻒f܂B
		 */
		bool hasValStr() const {
			return hasValStr_;
		}

		/**
		 * VALSTRɎw肵擾܂B
		 */
		const std::string& getValStr() const {
			return valstr_;
		}
	};

}  // namespace spcf

#endif
