/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: SAPIRecognition.hpp 26 2011-05-10 12:09:48Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_SAPI_SAPI_RECOGNITION_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_SAPI_SAPI_RECOGNITION_HPP_

#include "spcf/core/Recognition.hpp"

#include "spcf/sapi/utils/PhraseProperty.hpp"

#include <atlbase.h>
#include <sphelper.h>

#include <deque>
#include <string>

namespace spcf {

	class SAPIRecognition : public Recognition {
	private:
		CComPtr<ISpRecoResult> recognition_;
		SPPHRASE* phrase_;
		std::string rulename_;
		RecognitionPropertyContainer properties_;

	public:
		/**
		 * Fʂ\z܂B
		 */
		SAPIRecognition(CSpEvent& event);

		/**
		 * Fʂj܂B
		 */
		virtual ~SAPIRecognition();

	public:
		std::string getText();
		std::string getGrammarName();

	public:
		/**
		 * FʂLǂ𔻒肵܂B
		 *
		 * @return LȏꍇtrueAȏꍇfalseԂ܂B
		 */
		operator bool() const {
			return 0!=phrase_;
		}

		/**
		 * Fʂǂ𔻒肵܂B
		 *
		 * @return ȏꍇtrueALȏꍇfalseԂ܂B
		 */
		bool operator!() const {
			return 0==phrase_;
		}

	public:
		/**
		 * FΏۉWAVt@CɋL^܂B
		 */
		HRESULT record(const std::string& filename);

	public:
		/**
		 * vpeB̐擾܂B
		 */
		size_t sizeOfProperties() const {
			return properties_.size();
		}

		RecognitionPropertyIterator beginProperty() {
			return properties_.begin();
		}

		RecognitionPropertyConstIterator beginProperty() const {
			return properties_.begin();
		}

		RecognitionPropertyIterator endProperty() {
			return properties_.end();
		}

		RecognitionPropertyConstIterator endProperty() const {
			return properties_.end();
		}

	public:
		/**
		 * w肵ÕvpeB̐擾܂B
		 */
		size_t sizeOfProperties(const std::string& name) const;

		/**
		 * w肵CfbNX̃vpeB擾܂B
		 */
		RecognitionPropertyPtr getProperty(size_t index) const;

		RecognitionPropertyPtr getProperty(const std::string& name) const;

		/**
		 * w肵OnԖڂ̃vpeB擾܂B
		 */
		RecognitionPropertyPtr getProperty(const std::string& name, size_t n) const;
	};

}  // namespace spcf

#endif
