/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: GrammarPhrase.hpp 15 2011-05-09 06:59:42Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_CORE_GRAMMAR_PHRASE_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_CORE_GRAMMAR_PHRASE_HPP_

#include <string>

namespace spcf {

	class GrammarPhrase_i;

	class GrammarPhrase {
	private:
		GrammarPhrase_i *impl;

	public:
		GrammarPhrase();
		virtual ~GrammarPhrase();

	private:
		GrammarPhrase(const GrammarPhrase& phrase);
		GrammarPhrase& operator=(const GrammarPhrase& phrase);

	public:
		GrammarPhrase(const std::string& phrase);
		GrammarPhrase(const std::string& phrase, const std::string& name);
		GrammarPhrase(const std::string& phrase, const std::string& name, int val);
		GrammarPhrase(const std::string& phrase, const std::string& name, const std::string& valStr);
		GrammarPhrase(const std::string& phrase, const std::string& name, int val, const std::string& valStr);

	public:
		const std::string& getPhrase() const;

		bool hasProperty() const;

		const std::string& getPropertyName() const;

		bool hasPropertyVal() const;

		const int& getPropertyVal() const;

		bool hasPropertyValStr() const;

		const std::string& getPropertyValStr() const;
	};

}  // namespace spcf

#endif
