/**
 * ŏ̒:: gDC[
 * |Wg:: $Id: Grammar.hpp 15 2011-05-09 06:59:42Z yutaka_at_home $
 * 쌠:: Copyright (C) Ownway.info, 2011. All rights reserved.
 * CZX:: CPL(Common Public Licence)
 */

#ifndef _SPEECH_CONTROLLER_FRAMEWORK_CORE_GRAMMAR_HPP_
#define _SPEECH_CONTROLLER_FRAMEWORK_CORE_GRAMMAR_HPP_

#include <list>
#include <string>

#include <boost/shared_ptr.hpp>

namespace spcf {

	class GrammarTransition;
	typedef boost::shared_ptr<GrammarTransition> GrammarTransitionPtr;

	class Grammar {
	public:
		typedef std::string State;
		typedef std::list<GrammarTransitionPtr> GrammarTransitionList;

	public:
		static const State START_STATE_NAME;
		static const State FINISH_STATE_NAME;

	public:
		Grammar();
		virtual ~Grammar();

	private:
		Grammar(const Grammar& grammar);
		Grammar& operator=(const Grammar& grammar);

	public:
		virtual std::string getName() = 0;
		virtual GrammarTransitionList::const_iterator beginTransitions() = 0;
		virtual GrammarTransitionList::const_iterator endTransitions() = 0;
	};

}  // namespace spcf

#endif
