/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.Activator;
import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetView;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InputForm
extends Composite {
    private static Logger logger = Logger.getLogger(InputForm.class.getName());
    private Text text;
    private Button saveButton;
    private GadgetManager manager = GadgetManager.getInstance();
    private GadgetView view = (GadgetView)Activator.getDefault().getActivePart();

    public InputForm(Composite parent, int style) {
        super(parent, style);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(1040));
        Label label = new Label((Composite)this, 0);
        label.setText("\u30b3\u30fc\u30c9\u3092\u8cbc\u308a\u4ed8\u3051\u3066\u4fdd\u5b58\u3057\u3066\u304f\u3060\u3055\u3044\n<script>...</script>");
        Composite top = new Composite((Composite)this, 0);
        top.setLayout((Layout)new RowLayout(256));
        this.saveButton = new Button(top, 8);
        this.saveButton.setText("\u4fdd\u5b58");
        this.saveButton.setLayoutData((Object)new RowData(80, 20));
        this.saveButton.setEnabled(false);
        this.saveButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                logger.fine("OK");
                try {
                    Gadget newGadget = InputForm.this.manager.getGadgets().createGadget();
                    String source = InputForm.this.text.getText();
                    newGadget.setSource(source);
                    File file = InputForm.this.manager.createHtmlFile(newGadget);
                    newGadget.setFile(file);
                    InputForm.this.view.disposeSelectedTab();
                    InputForm.this.view.addBrowser(newGadget);
                    InputForm.this.view.setEnabledActions();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        Button cancelButton = new Button(top, 8);
        cancelButton.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        cancelButton.setLayoutData((Object)new RowData(80, 20));
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                logger.fine("CANCEL");
                try {
                    InputForm.this.view.disposeSelectedTab();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        this.text = new Text((Composite)this, 2882);
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget instanceof Text) {
                    if (((Text)e.widget).getText().length() > 0) {
                        InputForm.this.saveButton.setEnabled(true);
                    } else {
                        InputForm.this.saveButton.setEnabled(false);
                    }
                }
            }
        });
        DropTarget target = new DropTarget((Control)this.text, 17);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = 1;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                logger.fine("drop data = " + event.data);
                InputForm.this.text.setText(event.data.toString());
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        this.layout();
    }

    public boolean setFocus() {
        return this.text.setFocus();
    }
}

