/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.views;

import com.hisagisoft.eclipse.gadgetholder.Activator;
import com.hisagisoft.eclipse.gadgetholder.GadgetManager;
import com.hisagisoft.eclipse.gadgetholder.StructTitle;
import com.hisagisoft.eclipse.gadgetholder.actions.BackwardAction;
import com.hisagisoft.eclipse.gadgetholder.actions.ExportAction;
import com.hisagisoft.eclipse.gadgetholder.actions.ForwardAction;
import com.hisagisoft.eclipse.gadgetholder.actions.ImportAction;
import com.hisagisoft.eclipse.gadgetholder.actions.NewAction;
import com.hisagisoft.eclipse.gadgetholder.actions.RefreshAction;
import com.hisagisoft.eclipse.gadgetholder.actions.RemoveAction;
import com.hisagisoft.eclipse.gadgetholder.actions.RemoveAllAction;
import com.hisagisoft.eclipse.gadgetholder.actions.SaveAction;
import com.hisagisoft.eclipse.gadgetholder.actions.rollbackAction;
import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import com.hisagisoft.eclipse.gadgetholder.model.GadgetList;
import com.hisagisoft.eclipse.gadgetholder.views.GadgetDropListener;
import com.hisagisoft.eclipse.gadgetholder.views.InputForm;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.ViewPart;

public class GadgetView
extends ViewPart {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private CTabFolder folder;
    private GadgetManager manager;
    private GadgetList gadgets;
    private IAction forwardAction;
    private IAction backwardAction;
    private IAction refreshAction;
    private IAction newAction;
    private IAction removeAction;
    private IAction removeAllAction;
    private IAction saveAction;
    private IAction rollbackAction;
    private IAction importAction;
    private IAction exportAction;
    private StructTitle title;
    private ImageRegistry imageRegistry;

    public void createPartControl(Composite parent) {
        this.imageRegistry = Activator.getDefault().getImageRegistry();
        this.title = new StructTitle();
        this.title.put(StructTitle.Key.TITLE, this.getPartName());
        this.title.put(StructTitle.Key.UNSAVED, "");
        this.logger.fine("title = " + this.title);
        this.setPartName(this.title.toString());
        this.folder = new CTabFolder(parent, 0);
        this.manager = GadgetManager.getInstance();
        this.gadgets = this.manager.getGadgets();
        for (Gadget gadget : this.gadgets) {
            this.addBrowser(gadget);
        }
        this.makeActions();
        this.setEnabledActions();
        DropTarget target = new DropTarget((Control)this.folder, 17);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new GadgetDropListener(this));
    }

    public void addBrowser(Gadget gadget) {
        assert (gadget != null && this.folder != null);
        CTabItem item = new CTabItem(this.folder, 0);
        if (gadget.isRemoved()) {
            item.setImage(this.imageRegistry.get("IMG_OBJ_REMOVED"));
        } else if (gadget.isNew()) {
            item.setImage(this.imageRegistry.get("IMG_OBJ_NEW"));
        } else {
            item.setImage(this.imageRegistry.get("IMG_OBJ_FILE"));
        }
        this.folder.setSelection(item);
        Browser browser = new Browser((Composite)this.folder, 0);
        browser.setUrl(gadget.getFile().getAbsolutePath());
        item.setControl((Control)browser);
        item.setData(Gadget.class.getName(), (Object)gadget);
    }

    public void disposeSelectedTab() {
        CTabItem item = this.folder.getSelection();
        if (item != null) {
            if (item.getControl() != null) {
                item.getControl().dispose();
            }
            item.dispose();
        }
    }

    public void openInputFormTab() {
        CTabItem item = new CTabItem(this.folder, 0);
        item.setImage(this.imageRegistry.get("IMG_OBJ_NEW"));
        this.folder.setSelection(item);
        InputForm inputForm = new InputForm((Composite)this.folder, 0);
        item.setControl((Control)inputForm);
        inputForm.setFocus();
    }

    private void makeActions() {
        this.newAction = new NewAction(this);
        this.forwardAction = new ForwardAction(this);
        this.backwardAction = new BackwardAction(this);
        this.refreshAction = new RefreshAction(this);
        this.removeAction = new RemoveAction(this);
        this.removeAllAction = new RemoveAllAction(this);
        this.saveAction = new SaveAction(this);
        this.rollbackAction = new rollbackAction(this);
        this.importAction = new ImportAction(this);
        this.exportAction = new ExportAction(this);
        IToolBarManager bars = this.getViewSite().getActionBars().getToolBarManager();
        bars.add(this.backwardAction);
        bars.add(this.refreshAction);
        bars.add(this.forwardAction);
        bars.add((IContributionItem)new Separator());
        bars.add(this.newAction);
        bars.add(this.removeAction);
        bars.add(this.removeAllAction);
        bars.add((IContributionItem)new Separator());
        bars.add(this.saveAction);
        bars.add(this.rollbackAction);
        bars.add((IContributionItem)new Separator());
        bars.add(this.importAction);
        bars.add(this.exportAction);
    }

    public void setEnabledActions() {
        this.newAction.setEnabled(true);
        this.importAction.setEnabled(true);
        if (this.gadgets.size() > 0) {
            this.refreshAction.setEnabled(true);
            this.removeAction.setEnabled(true);
            this.removeAllAction.setEnabled(true);
            this.exportAction.setEnabled(true);
        } else {
            this.refreshAction.setEnabled(false);
            this.removeAction.setEnabled(false);
            this.removeAllAction.setEnabled(false);
            this.exportAction.setEnabled(false);
        }
        if (this.gadgets.size() > 1) {
            this.forwardAction.setEnabled(true);
            this.backwardAction.setEnabled(true);
        } else {
            this.forwardAction.setEnabled(false);
            this.backwardAction.setEnabled(false);
        }
        if (this.gadgets.isModified()) {
            this.saveAction.setEnabled(true);
            this.rollbackAction.setEnabled(true);
            this.title.put(StructTitle.Key.UNSAVED, "*");
        } else {
            this.saveAction.setEnabled(false);
            this.rollbackAction.setEnabled(false);
            this.title.put(StructTitle.Key.UNSAVED, "");
        }
        this.setPartName(this.title.toString());
    }

    public void disposeDeadTab() {
        CTabItem[] cTabItemArray = this.folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
            if (gadget != null && !this.gadgets.contains(gadget)) {
                item.getControl().dispose();
                item.dispose();
            }
            ++n2;
        }
    }

    public void updateItemIcon() {
        CTabItem[] cTabItemArray = this.folder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Gadget gadget = (Gadget)item.getData(Gadget.class.getName());
            if (gadget != null) {
                if (gadget.isRemoved()) {
                    item.setImage(this.imageRegistry.get("IMG_OBJ_REMOVED"));
                } else if (gadget.isNew()) {
                    item.setImage(this.imageRegistry.get("IMG_OBJ_NEW"));
                } else {
                    item.setImage(this.imageRegistry.get("IMG_OBJ_FILE"));
                }
            }
            ++n2;
        }
    }

    public Gadget getSelectedGadget() {
        return (Gadget)this.folder.getSelection().getData(Gadget.class.getName());
    }

    public CTabItem getSelectedTabItem() {
        return this.folder.getSelection();
    }

    public void setFocus() {
    }

    public void changeNextTab() {
        int count;
        if (this.folder.getSelection() == null) {
            return;
        }
        int current = this.folder.getSelectionIndex();
        if (current == (count = this.folder.getItemCount()) - 1) {
            this.folder.setSelection(0);
        } else {
            this.folder.setSelection(current + 1);
        }
    }

    public void changePrevTab() {
        if (this.folder.getSelection() == null) {
            return;
        }
        int current = this.folder.getSelectionIndex();
        int count = this.folder.getItemCount();
        if (current == 0) {
            this.folder.setSelection(count - 1);
        } else {
            this.folder.setSelection(current - 1);
        }
    }

    public void refreshActiveBrowser() {
        if (this.refreshAction.isEnabled()) {
            this.refreshAction.run();
        }
    }

    public void removeGadget() {
        if (this.removeAction.isEnabled()) {
            this.removeAction.run();
        }
    }

    public void saveGadget() {
        if (this.saveAction.isEnabled()) {
            this.saveAction.run();
        }
    }

    public void rollbackGadget() {
        if (this.rollbackAction.isEnabled()) {
            this.rollbackAction.run();
        }
    }
}

