/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.gadgetholder.model;

import com.hisagisoft.eclipse.gadgetholder.model.Gadget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetList
implements List<Gadget> {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private List<Gadget> list = new ArrayList<Gadget>();

    public synchronized Gadget createGadget() {
        Gadget newGadget = new Gadget();
        newGadget.setNew(true);
        int newId = -1;
        for (Gadget g : this.list) {
            newId = Math.max(g.getId(), newId);
        }
        this.logger.fine("new id = " + ++newId);
        newGadget.setId(newId);
        this.add(newGadget);
        return newGadget;
    }

    public boolean isModified() {
        for (Gadget g : this.list) {
            if (!g.isNew() && !g.isRemoved()) continue;
            return true;
        }
        return false;
    }

    public synchronized void commit() {
        ArrayList<Gadget> removeList = new ArrayList<Gadget>();
        for (Gadget g : this.list) {
            if (g.isRemoved()) {
                this.logger.fine("remove gadget.id = " + g.getId());
                removeList.add(g);
            }
            if (!g.isNew()) continue;
            g.setNew(false);
        }
        this.list.removeAll(removeList);
        this.logger.fine("size of list = " + this.list.size());
    }

    public synchronized void rollback() {
        ArrayList<Gadget> removeList = new ArrayList<Gadget>();
        for (Gadget g : this.list) {
            if (g.isRemoved()) {
                g.setRemoved(false);
            }
            if (!g.isNew()) continue;
            this.logger.fine("remove gadget.id = " + g.getId());
            removeList.add(g);
        }
        this.list.removeAll(removeList);
        this.logger.fine("size of list = " + this.list.size());
    }

    @Override
    public boolean add(Gadget o) {
        return this.list.add(o);
    }

    @Override
    public void add(int index, Gadget element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Gadget> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Gadget> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Gadget get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<Gadget> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Gadget> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Gadget> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Gadget remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Gadget set(int index, Gadget element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<Gadget> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }
}

