<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Resource module upgrade related helper functions
 *
 * @package    mod
 * @subpackage scorm
 * @copyright  2010 Petr Skoda  {@link http://skodak.org}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die;

/**
 * Migrate extracted scorm package from moddata to new area if found
 * @param stdClass $scorm
 * @return
 */
function scorm_migrate_moddata_files($scorm, $context) {
    global $CFG;

    // now migrate the extracted package
    $basepath = "$CFG->dataroot/$scorm->course/$CFG->moddata/scorm/$scorm->id";
    if (!is_dir($basepath)) {
        //no files?
        return;
    }

    scorm_migrate_moddata_subdir($context, $basepath, '/');
}
/**
 * Migrates physical scorm package files to proper new file area files
 * @param stdClass $context
 * @param string $base
 * @param string $path
 * @return void
 */
function scorm_migrate_moddata_subdir($context, $base, $path) {
    global $OUTPUT;

    $fullpathname = $base.$path;
    $fs           = get_file_storage();
    $filearea     = 'content';
    $items        = new DirectoryIterator($fullpathname);

    foreach ($items as $item) {
        if ($item->isDot()) {
            unset($item); // release file handle
            continue;
        }

        if ($item->isLink()) {
            // do not follow symlinks - they were never supported in moddata, sorry
            unset($item); // release file handle
            continue;
        }

        if ($item->isFile()) {
            if (!$item->isReadable()) {
// (FS_CONVERTER): ここから
//              echo $OUTPUT->notification(" File not readable, skipping: ".$fullpathname.$item->getFilename());
                echo $OUTPUT->notification(" File not readable, skipping: ".$fullpathname.fsCharset2currentCharset($item->getFilename()));
// (FS_CONVERTER): ここまで
                unset($item); // release file handle
                continue;
            }

            $filepath    = clean_param($path, PARAM_PATH);
// (FS_CONVERTER): ここから
//          $filename    = clean_param($item->getFilename(), PARAM_FILE);
            $filename    = clean_param(fsCharset2currentCharset($item->getFilename()), PARAM_FILE);
//          $oldpathname = $fullpathname.$item->getFilename();
            $oldpathname = $fullpathname.fsCharset2currentCharset($item->getFilename());
// (FS_CONVERTER): ここまで

            if ($filename === '') {
                continue;
                unset($item); // release file handle
            }

            if (!$fs->file_exists($context->id, 'mod_scorm', $filearea, '0', $filepath, $filename)) {
                $file_record = array('contextid'=>$context->id, 'component'=>'mod_scorm', 'filearea'=>$filearea, 'itemid'=>0, 'filepath'=>$filepath, 'filename'=>$filename,
                                     'timecreated'=>$item->getCTime(), 'timemodified'=>$item->getMTime());
                unset($item); // release file handle
// (Shirai204): Moodle2.0へのMigrationで非常に大きなファイルをコピーするような場合はタイムアウトの設定をリセットして延長する改良 (2010/12/13)
// (Shirai204): ここから追加
                upgrade_set_timeout(180); // set up timeout, may also abort execution
                echo '.';
// (Shirai204): ここまで追加
                if ($fs->create_file_from_pathname($file_record, $oldpathname)) {
// (FS_CONVERTER): ここから
//                  @unlink($oldpathname);
                    @fs_unlink($oldpathname);
// (FS_CONVERTER): ここまで
                }
            } else {
                unset($item); // release file handle
            }

        } else {
            //migrate recursively all subdirectories
// (FS_CONVERTER): ここから
//          $oldpathname = $fullpathname.$item->getFilename().'/';
            $oldpathname = $fullpathname.fsCharset2currentCharset($item->getFilename()).'/';
//          $subpath     = $path.$item->getFilename().'/';
            $subpath     = $path.fsCharset2currentCharset($item->getFilename()).'/';
// (FS_CONVERTER): ここまで
            unset($item);  // release file handle
            scorm_migrate_moddata_subdir($context, $base, $subpath);
// (FS_CONVERTER): ここから
//          @rmdir($oldpathname); // deletes dir if empty
            @fs_rmdir($oldpathname); // deletes dir if empty
// (FS_CONVERTER): ここまで
        }
    }
    unset($items); //release file handles
}
