package com.small_it_office.flatserve.fileupload.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;

import javax.servlet.ServletConfig;

import com.small_it_office.flatserve.core.config.Config;
import com.small_it_office.flatserve.core.plugin.internal.PluginPart;
import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.internal.NullObject;
import com.small_it_office.flatserve.core.request.internal.ParameterHolder;
import com.small_it_office.flatserve.core.request.internal.RequestParameterMapper;
import com.small_it_office.flatserve.core.util.internal.AnnotationUtil;
import com.small_it_office.flatserve.fileupload.FileItem;
import com.small_it_office.flatserve.fileupload.FileParam;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * }`p[gNGXgɑΉRequestParameterMapper̎łB
 * Abv[hꂽt@CHTTPT[rX\bḧɃ}bsO܂B
 */
public class FileUploadParameterMapper implements RequestParameterMapper {

	/**
	 * ̃vOCi̗D揇ʁB
	 */
	private static final int PLUGIN_PRIORITY = 256;

	/**
	 * lXgIuWFNgB
	 */
	private RequestParameterMapper nested;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	public ParameterHolder process(Class<?> serviceClass, Method method, ParameterHolder mappedParams) {
		logger.debug("FSFUP-LOGD004");
		Map<String, Object> requestParams = RequestContext.get().getRequestParams();
		Class<?>[] paramTypes = method.getParameterTypes();
		Annotation[][] paramsAnnotations = method.getParameterAnnotations();
		for (int i = 0; i < paramTypes.length; i++) {
			if (mappedParams.getParam(i) != null) {
				logger.debug("FSFUP-LOGD006", i + 1, mappedParams.getParam(i));
				continue;
			}
			FileParam fileParamAnnotation = AnnotationUtil.findAnnotation(paramsAnnotations[i], FileParam.class);
			if (fileParamAnnotation != null) {
				String partName = fileParamAnnotation.value();
				Object objFileItems = requestParams.get(partName);
				if (objFileItems == null) {
					logger.debug("FSFUP-LOGD007", i + 1, partName);
				} else if (!(objFileItems instanceof FileItem[])) {
					logger.debug("FSFUP-LOGD008", i + 1);
				} else {
					FileItem[] fileItems = (FileItem[])objFileItems;
					putFileParam(mappedParams, paramTypes[i], fileItems, i);
					if (logger.isDebugEnabled()) {
						if (mappedParams.getParam(i) != null) {
							logger.debug("FSFUP-LOGD009", i + 1, partName);
						} else {
							logger.debug("FSFUP-LOGD010", i + 1);
						}
					}
				}
			}
			//FileItem^̈null̏ꍇɁAcoreɂBeanp[^ƔF邱ƂB
			if (paramTypes[i] == FileItem.class && mappedParams.getParam(i) == null) {
				mappedParams.setParam(i, NullObject.getInstance());
			}
		}

		ParameterHolder result = nested.process(serviceClass, method, mappedParams);
		logger.debug("FSFUP-LOGD005");
		return result;
	}

	/**
	 * t@CeɃCWFNV邽߂ɁA^ɍ킹`̃IuWFNg𐶐ParameterHolderɊi[܂B
	 * ^́Abyte[]A{@link FileItem}Aт̔zĩp[gŕ̃t@CAbv[h\jłB
	 * ^K؂łȂꍇnulli[܂B
	 * @param mappedParams \bhɓnێIuWFNgB
	 * @param paramType CWFNV̌^B
	 * @param fileItems NGXgǂݍݍς݂̃t@CeB
	 * @param index Ώۈ̃CfbNXB
	 */
	private void putFileParam(ParameterHolder mappedParams, Class<?> paramType, FileItem[] fileItems, int index) {
	    if (paramType == FileItem.class) {
	    	mappedParams.setRawParam(index, fileItems[0]);
	    	mappedParams.setParam(index, fileItems[0]);
	    } else if (paramType == FileItem[].class) {
	    	mappedParams.setRawParam(index, fileItems);
	    	mappedParams.setParam(index, fileItems);
	    } else if (paramType == byte[].class) {
	    	mappedParams.setRawParam(index, fileItems[0]);
	    	mappedParams.setParam(index, fileItems[0].getFile());
	    } else if (paramType == byte[][].class) {
	    	mappedParams.setRawParam(index, fileItems);
	    	byte[][] fileBytes = new byte[fileItems.length][];
	    	for (int j = 0; j < fileBytes.length; j++) {
	    		fileBytes[j] = fileItems[j].getFile();
	    	}
	    	mappedParams.setParam(index, fileBytes);
	    } else {
	    	mappedParams.setRawParam(index, null);
	    	mappedParams.setParam(index, null);
	    }
    }

	/**
	 * {@inheritDoc}
	 */
	public void init(Config config, ServletConfig servletConfig) {
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean nest() {
		return true;
	}

	/**
	 * {@inheritDoc}
	 */
	public int priority() {
		return PLUGIN_PRIORITY;
	}

	/**
	 * {@inheritDoc}
	 */
	public void setNestedObject(PluginPart o) {
		nested = (RequestParameterMapper)o;
	}

}
