package com.small_it_office.flatserve.fileupload.internal;

import java.lang.reflect.Field;
import java.util.Map;

import com.small_it_office.flatserve.core.process.internal.RequestContext;
import com.small_it_office.flatserve.core.request.bean.internal.BeanMappedParameter;
import com.small_it_office.flatserve.core.request.bean.internal.BeanParameterMapper;
import com.small_it_office.flatserve.fileupload.FileItem;
import com.small_it_office.flatserve.fileupload.FileParam;
import com.small_it_office.shared.meslog.log.Logger;
import com.small_it_office.shared.meslog.log.LoggerFactory;

/**
 * t@C̃Abv[hɑΉRequestParameterMapper̎NXłB
 */
public class FileUploadBeanParameterMapper extends BeanParameterMapper {

	/**
	 * BeanParameterMapper̗D揇ʁB
	 */
	private static final int PRIORITY = 256;

	/**
	 * Logger̃CX^XB
	 */
	private Logger logger = LoggerFactory.getInstance().getLogger(this.getClass());

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getPriority() {
		return PRIORITY;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public BeanMappedParameter process(Field field, BeanMappedParameter param) {
		logger.debug("FSFUP-LOGD011", this.getClass().getSimpleName(), field.getName());
		if (param.getParam() == null) {
			mapIfFileParam(field, param);
		} else {
			logger.debug("FSFUP-LOGD015", param.getParam());
		}

		param = getNestedReader().process(field, param);

		logger.debug("FSFUP-LOGD012", this.getClass().getSimpleName(), field.getName());
		return param;
	}

	/**
	 * tB[hɊi[t@CIuWFNgAǂݍݍς݂̃NGXgp[^}bsO܂B
	 * w肳ꂽtB[ht@Ci[tB[hłȂꍇ͉s܂B
	 * @param field tB[hB
	 * @param param }bsOꂽli[IuWFNgB
	 */
	private void mapIfFileParam(Field field, BeanMappedParameter param) {
	    Map<String, Object> requestParams = RequestContext.get().getRequestParams();
	    FileParam fileParamAnnotation = field.getAnnotation(FileParam.class);
	    if (field.getType() == FileItem.class) {
	    	String paramName = fileParamAnnotation == null ? field.getName() : fileParamAnnotation.value();
	    	FileItem[] fileItems = getRequestParam(paramName, requestParams);
	    	if (fileItems != null) {
	    		param.setParamName(paramName);
	    		param.setParam(fileItems[0]);
	    		param.setRawParam(fileItems[0]);
	    	}
	    } else if (field.getType() == FileItem[].class) {
	    	String paramName = fileParamAnnotation == null ? field.getName() : fileParamAnnotation.value();
	    	FileItem[] fileItems = getRequestParam(paramName, requestParams);
	    	if (fileItems != null) {
	    		param.setParamName(paramName);
	    		param.setParam(fileItems);
	    		param.setRawParam(fileItems);
	    	}
	    } else if (field.getType() == byte[].class && fileParamAnnotation != null) {
	    	String paramName = fileParamAnnotation.value();
	    	FileItem[] fileItems = getRequestParam(paramName, requestParams);
	    	if (fileItems != null) {
	    		param.setParamName(paramName);
	    		param.setParam(fileItems[0].getFile());
	    		param.setRawParam(fileItems[0]);
	    	}
	    } else if (field.getType() == byte[][].class && fileParamAnnotation != null) {
	    	String paramName = fileParamAnnotation.value();
	    	FileItem[] fileItems = getRequestParam(paramName, requestParams);
	    	if (fileItems != null) {
	    		param.setParamName(paramName);
	    		byte[][] value = new byte[fileItems.length][];
	    		for (int i = 0; i < value.length; i++) {
	    			value[i] = fileItems[i].getFile();
	    		}
	    		param.setParam(value);
	    		param.setRawParam(fileItems);
	    	}
	    }
    }

	/**
	 * NGXgIuWFNgǂݍݍς݂̃NGXgp[^MapA
	 * w肵OŊi[ꂽt@CIuWFNg擾܂B
	 * lnullłꍇA{@link FileItem}̔zȊǑ^Ŋi[ĂꍇnullԂ܂B
	 * @param paramName MapɊi[ĂIuWFNg̃p[^B
	 * @param requestParams ǂݍݍς݂̃NGXgp[^B
	 * @return t@CIuWFNgi[Ăꍇ͂̃IuWFNgB
	 */
	private FileItem[] getRequestParam(String paramName, Map<String, Object> requestParams) {
	    Object objFileItems = requestParams.get(paramName);
	    FileItem[] fileItems = null;
	    if (objFileItems == null) {
	    	logger.debug("FSFUP-LOGD013", paramName);
	    } else if (!(objFileItems instanceof FileItem[])) {
	    	logger.debug("FSFUP-LOGD014", paramName);
	    } else {
	    	fileItems = (FileItem[])objFileItems;
	    }
	    return fileItems;
    }

}
