/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Lambda;
import com.github.jknack.handlebars.MissingValueResolver;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.HelperResolver;
import com.github.jknack.handlebars.internal.Lambdas;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class Variable
extends HelperResolver {
    private final String name;
    private final TagType type;
    private final Object constant;
    private MissingValueResolver missingValueResolver;
    private String startDelimiter;
    private String endDelimiter;

    public Variable(Handlebars handlebars, String name, TagType type, List<Object> params, Map<String, Object> hash) {
        this(handlebars, name, null, type, params, hash);
    }

    public Variable(Handlebars handlebars, String name, Object value, TagType type, List<Object> params, Map<String, Object> hash) {
        super(handlebars);
        this.missingValueResolver = handlebars.getMissingValueResolver();
        this.name = name.trim();
        this.constant = value;
        this.type = type;
        this.params(params);
        this.hash(hash);
    }

    public Variable(Handlebars handlebars, String name, Object value, TagType type) {
        this(handlebars, name, value, type, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
    }

    public String name() {
        return this.name;
    }

    @Override
    protected void merge(Context scope, Writer writer) throws IOException {
        Helper<Object> helper = this.helper(this.name);
        if (helper != null) {
            Options options = new Options.Builder(this.handlebars, this.type, scope, Template.EMPTY).setParams(this.params(scope)).setHash(this.hash(scope)).build();
            options.data(Context.PARAM_SIZE, this.params.size());
            CharSequence result = helper.apply(this.determineContext(scope), options);
            if (this.escape(result)) {
                writer.append(Handlebars.Utils.escapeExpression(result));
            } else if (result != null) {
                writer.append(result);
            }
        } else {
            Object value;
            Object object = value = this.constant == null ? scope.get(this.name) : this.constant;
            if (value == null) {
                value = this.missingValueResolver.resolve(this.determineContext(scope), this.name);
            }
            if (value != null) {
                if (value instanceof Lambda) {
                    value = Lambdas.merge(this.handlebars, (Lambda)value, scope, this);
                }
                String stringValue = value.toString();
                if (this.escape(value)) {
                    writer.append(Handlebars.Utils.escapeExpression(stringValue));
                } else {
                    writer.append(stringValue);
                }
            }
        }
    }

    @Override
    protected void collect(Collection<String> result, TagType tagType) {
        if (this.type == tagType) {
            result.add(this.name);
        }
    }

    private boolean escape(Object value) {
        if (value instanceof Handlebars.SafeString) {
            return false;
        }
        return this.type == TagType.VAR;
    }

    @Override
    public String text() {
        String hash;
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.startDelimiter).append(this.name);
        String params = this.paramsToString();
        if (params.length() > 0) {
            buffer.append(" ").append(params);
        }
        if ((hash = this.hashToString()).length() > 0) {
            buffer.append(" ").append(hash);
        }
        return buffer.append(this.endDelimiter).toString();
    }

    public Variable endDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
        return this;
    }

    public Variable startDelimiter(String startDelimiter) {
        this.startDelimiter = startDelimiter;
        return this;
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }
}

