/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import javax.sql.DataSource;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractQueryDynamicCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnCommandContextHandler;
import org.seasar.dbflute.twowaysql.context.CommandContext;

public class TnQueryDeleteDynamicCommand
extends TnAbstractQueryDynamicCommand {
    public TnQueryDeleteDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    public Object execute(Object[] args) {
        ConditionBean cb = this.extractConditionBeanWithCheck(args);
        DeleteOption<ConditionBean> option = this.extractUpdateOptionWithCheck(args);
        this.prepareStatementConfigOnThreadIfExists(option);
        String[] argNames = new String[]{"pmb"};
        Class[] argTypes = new Class[]{cb.getClass()};
        Object[] realArgs = new Object[]{cb};
        String twoWaySql = this.buildQueryDeleteTwoWaySql(cb, option);
        CommandContext context = this.createCommandContext(twoWaySql, argNames, argTypes, realArgs);
        TnCommandContextHandler handler = this.createCommandContextHandler(context);
        handler.setExceptionMessageSqlArgs(context.getBindVariables());
        int rows = handler.execute(realArgs);
        return rows;
    }

    protected ConditionBean extractConditionBeanWithCheck(Object[] args) {
        this.assertArgument(args);
        Object fisrtArg = args[0];
        if (!(fisrtArg instanceof ConditionBean)) {
            String msg = "The type of first argument should be " + ConditionBean.class + ":";
            msg = msg + " type=" + fisrtArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        return (ConditionBean)fisrtArg;
    }

    protected DeleteOption<ConditionBean> extractUpdateOptionWithCheck(Object[] args) {
        this.assertArgument(args);
        if (args.length < 2) {
            return null;
        }
        Object secondArg = args[1];
        if (secondArg == null) {
            return null;
        }
        if (!(secondArg instanceof DeleteOption)) {
            String msg = "The type of second argument should be " + DeleteOption.class + ":";
            msg = msg + " type=" + secondArg.getClass();
            throw new IllegalArgumentException(msg);
        }
        DeleteOption option = (DeleteOption)secondArg;
        return option;
    }

    protected void prepareStatementConfigOnThreadIfExists(DeleteOption<ConditionBean> option) {
        StatementConfig config;
        StatementConfig statementConfig = config = option != null ? option.getDeleteStatementConfig() : null;
        if (config != null) {
            InternalMapContext.setUpdateStatementConfig(config);
        }
    }

    protected void assertArgument(Object[] args) {
        if (args == null || args.length <= 1) {
            String msg = "The arguments should have two argument at least! But:";
            msg = msg + " args=" + (args != null ? Integer.valueOf(args.length) : null);
            throw new IllegalArgumentException(msg);
        }
    }

    protected String buildQueryDeleteTwoWaySql(ConditionBean cb, DeleteOption<ConditionBean> option) {
        if (option != null && option.isQueryDeleteForcedDirectAllowed()) {
            cb.getSqlClause().allowQueryUpdateForcedDirect();
        }
        return cb.getSqlClause().getClauseQueryDelete();
    }

    @Override
    protected String getUpdateSQLFailureProcessTitle() {
        return "query delete";
    }
}

