/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.sqlcommand;

import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.dbmeta.name.ColumnSqlName;
import org.seasar.dbflute.exception.factory.ExceptionMessageBuilder;
import org.seasar.dbflute.jdbc.StatementConfig;
import org.seasar.dbflute.jdbc.StatementFactory;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.s2dao.identity.TnIdentifierGenerator;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.sqlcommand.TnAbstractEntityDynamicCommand;
import org.seasar.dbflute.s2dao.sqlhandler.TnInsertEntityHandler;

public class TnInsertEntityDynamicCommand
extends TnAbstractEntityDynamicCommand {
    public TnInsertEntityDynamicCommand(DataSource dataSource, StatementFactory statementFactory) {
        super(dataSource, statementFactory);
    }

    @Override
    public Object execute(Object[] args) {
        if (args == null || args.length == 0) {
            String msg = "The argument 'args' should not be null or empty.";
            throw new IllegalArgumentException(msg);
        }
        Object bean = args[0];
        InsertOption<ConditionBean> option = this.extractInsertOptionChecked(args);
        this.prepareStatementConfigOnThreadIfExists(option);
        TnBeanMetaData bmd = this._beanMetaData;
        TnPropertyType[] propertyTypes = this.createInsertPropertyTypes(bmd, bean, this._propertyNames, option);
        String sql = this.filterExecutedSql(this.createInsertSql(bmd, propertyTypes, option));
        return this.doExecute(bean, propertyTypes, sql, option);
    }

    protected InsertOption<ConditionBean> extractInsertOptionChecked(Object[] args) {
        if (args.length < 2 || args[1] == null) {
            return null;
        }
        InsertOption option = (InsertOption)args[1];
        return option;
    }

    protected void prepareStatementConfigOnThreadIfExists(InsertOption<ConditionBean> option) {
        StatementConfig config;
        StatementConfig statementConfig = config = option != null ? option.getInsertStatementConfig() : null;
        if (config != null) {
            InternalMapContext.setUpdateStatementConfig(config);
        }
    }

    protected Object doExecute(Object bean, TnPropertyType[] propertyTypes, String sql, InsertOption<ConditionBean> option) {
        TnInsertEntityHandler handler = this.createInsertEntityHandler(propertyTypes, sql, option);
        Object[] realArgs = new Object[]{bean};
        handler.setExceptionMessageSqlArgs(realArgs);
        int rows = handler.execute(realArgs);
        return rows;
    }

    protected TnPropertyType[] createInsertPropertyTypes(TnBeanMetaData bmd, Object bean, String[] propertyNames, InsertOption<ConditionBean> option) {
        if (0 == propertyNames.length) {
            String msg = "The property name was not found in the bean: " + bean;
            throw new IllegalStateException(msg);
        }
        ArrayList<TnPropertyType> typeList = new ArrayList<TnPropertyType>();
        String timestampPropertyName = bmd.getTimestampPropertyName();
        String versionNoPropertyName = bmd.getVersionNoPropertyName();
        for (int i = 0; i < propertyNames.length; ++i) {
            TnIdentifierGenerator generator;
            TnPropertyType pt = bmd.getPropertyType(propertyNames[i]);
            if (pt.isPrimaryKey() ? (option == null || !option.isPrimaryKeyIdentityDisabled()) && !(generator = bmd.getIdentifierGenerator(pt.getPropertyName())).isSelfGenerate() : this.isExceptProperty(bean, pt, timestampPropertyName, versionNoPropertyName)) continue;
            typeList.add(pt);
        }
        if (typeList.isEmpty()) {
            this.throwEntityInsertPropertyNotFoundException(bmd, bean);
        }
        return typeList.toArray(new TnPropertyType[typeList.size()]);
    }

    protected void throwEntityInsertPropertyNotFoundException(TnBeanMetaData bmd, Object bean) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The insert property of the entity was not found.");
        br.addItem("Advice");
        br.addElement("The entity should have one or more insert properties.");
        br.addElement("For example, an identity-column-only table is unsupported.");
        br.addItem("Table");
        br.addElement(bmd.getTableName());
        br.addItem("Entity");
        br.addElement(bean != null ? bean.getClass() : null);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected boolean isExceptProperty(Object bean, TnPropertyType pt, String timestampPropertyName, String versionNoPropertyName) {
        if (this.isOptimisticLockProperty(pt, timestampPropertyName, versionNoPropertyName)) {
            return false;
        }
        return this.isNullProperty(bean, pt);
    }

    protected boolean isOptimisticLockProperty(TnPropertyType pt, String timestampPropertyName, String versionNoPropertyName) {
        String propertyName = pt.getPropertyName();
        return propertyName.equalsIgnoreCase(timestampPropertyName) || propertyName.equalsIgnoreCase(versionNoPropertyName);
    }

    protected boolean isNullProperty(Object bean, TnPropertyType pt) {
        return pt.getPropertyDesc().getValue(bean) == null;
    }

    protected String createInsertSql(TnBeanMetaData bmd, TnPropertyType[] propertyTypes, InsertOption<ConditionBean> option) {
        String tableDbName = this._targetDBMeta.getTableDbName();
        StringBuilder columnSb = new StringBuilder(48);
        StringBuilder valuesSb = new StringBuilder(48);
        for (int i = 0; i < propertyTypes.length; ++i) {
            TnPropertyType pt = propertyTypes[i];
            ColumnSqlName columnSqlName = pt.getColumnSqlName();
            if (i > 0) {
                columnSb.append(", ");
                valuesSb.append(", ");
            }
            columnSb.append(columnSqlName);
            String columnDbName = pt.getColumnDbName();
            valuesSb.append(this.encryptIfNeeds(tableDbName, columnDbName, "?"));
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("insert into ").append(this._targetDBMeta.getTableSqlName());
        sb.append(" (").append((CharSequence)columnSb).append(")");
        sb.append(this.ln()).append(" values (").append((CharSequence)valuesSb).append(")");
        return sb.toString();
    }

    protected TnInsertEntityHandler createInsertEntityHandler(TnPropertyType[] boundPropTypes, String sql, InsertOption<ConditionBean> option) {
        TnInsertEntityHandler handler = new TnInsertEntityHandler(this._dataSource, this._statementFactory, sql, this._beanMetaData, boundPropTypes);
        handler.setInsertOption(option);
        return handler;
    }
}

