/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.rowcreator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnPropertyType;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyType;
import org.seasar.dbflute.s2dao.rowcreator.TnRelationKey;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRelationKeyCompound;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRelationKeyEmpty;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRelationKeySimple;

public class TnRelationRowCache {
    private static final TnRelationKey EMPTY_KEY = new TnRelationKeyEmpty();
    protected final Map<String, Map<TnRelationKey, Object>> _rowMap;
    protected final boolean _canCache;

    public TnRelationRowCache(int relSize, boolean canCache) {
        this._rowMap = canCache ? new HashMap(relSize) : null;
        this._canCache = canCache;
    }

    public Object getRelationRow(String relationNoSuffix, TnRelationKey relKey) {
        if (!this._canCache) {
            return null;
        }
        Map<TnRelationKey, Object> elementMap = this._rowMap.get(relationNoSuffix);
        if (elementMap == null) {
            return null;
        }
        return elementMap.get(relKey);
    }

    public void addRelationRow(String relationNoSuffix, TnRelationKey relKey, Object relationRow) {
        if (!this._canCache) {
            return;
        }
        Map<TnRelationKey, Object> elementMap = this._rowMap.get(relationNoSuffix);
        if (elementMap == null) {
            elementMap = new HashMap<TnRelationKey, Object>();
            this._rowMap.put(relationNoSuffix, elementMap);
        }
        elementMap.put(relKey, relationRow);
    }

    public TnRelationKey createRelationKey(ResultSet rs, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Integer> selectIndexMap, String relationNoSuffix) throws SQLException {
        if (!this._canCache) {
            return EMPTY_KEY;
        }
        TnRelationKey relKey = rpt.hasSimpleUniqueKey() ? this.doCreateRelationKeySimple(rs, rpt, selectColumnMap, selectIndexMap, relationNoSuffix) : (rpt.hasCompoundUniqueKey() ? this.doCreateRelationKeyCompound(rs, rpt, selectColumnMap, selectIndexMap, relationNoSuffix) : null);
        return relKey;
    }

    protected TnRelationKey doCreateRelationKeySimple(ResultSet rs, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Integer> selectIndexMap, String relationNoSuffix) throws SQLException {
        TnPropertyType pt = rpt.getSimpleUniquePropertyType();
        String columnLabel = this.buildColumnLabel(pt, relationNoSuffix);
        Object keyValue = this.setupKeyElement(rs, rpt, selectColumnMap, selectIndexMap, columnLabel, pt);
        return keyValue != null ? new TnRelationKeySimple(columnLabel, keyValue) : null;
    }

    protected TnRelationKey doCreateRelationKeyCompound(ResultSet rs, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Integer> selectIndexMap, String relationNoSuffix) throws SQLException {
        List<TnPropertyType> uniquePropertyTypeList = rpt.getUniquePropertyTypeList();
        HashMap<String, Object> relKeyValues = null;
        for (TnPropertyType pt : uniquePropertyTypeList) {
            String columnLabel = this.buildColumnLabel(pt, relationNoSuffix);
            Object keyValue = this.setupKeyElement(rs, rpt, selectColumnMap, selectIndexMap, columnLabel, pt);
            if (keyValue == null) {
                if (relKeyValues == null) break;
                relKeyValues.clear();
                break;
            }
            if (relKeyValues == null) {
                relKeyValues = new HashMap<String, Object>(uniquePropertyTypeList.size());
            }
            relKeyValues.put(columnLabel, keyValue);
        }
        return relKeyValues != null && !relKeyValues.isEmpty() ? new TnRelationKeyCompound((Map<String, Object>)relKeyValues) : null;
    }

    protected String buildColumnLabel(TnPropertyType pt, String relationNoSuffix) {
        return pt.getColumnDbName() + relationNoSuffix;
    }

    protected Object setupKeyElement(ResultSet rs, TnRelationPropertyType rpt, Map<String, String> selectColumnMap, Map<String, Integer> selectIndexMap, String columnLabel, TnPropertyType pt) throws SQLException {
        if (!selectColumnMap.containsKey(columnLabel)) {
            return null;
        }
        ValueType valueType = pt.getValueType();
        Object value = selectIndexMap != null ? ResourceContext.getValue(rs, columnLabel, valueType, selectIndexMap) : valueType.getValue(rs, columnLabel);
        return value;
    }

    public Map<String, Map<TnRelationKey, Object>> getRowMap() {
        return this._rowMap;
    }
}

