/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.metadata.impl;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.dbflute.exception.handler.SQLExceptionHandler;
import org.seasar.dbflute.exception.handler.SQLExceptionResource;
import org.seasar.dbflute.jdbc.LazyDatabaseMetaDataWrapper;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanAnnotationReader;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaDataFactory;
import org.seasar.dbflute.s2dao.metadata.TnModifiedPropertySupport;
import org.seasar.dbflute.s2dao.metadata.TnPropertyTypeFactory;
import org.seasar.dbflute.s2dao.metadata.TnPropertyTypeFactoryBuilder;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyTypeFactory;
import org.seasar.dbflute.s2dao.metadata.TnRelationPropertyTypeFactoryBuilder;
import org.seasar.dbflute.s2dao.metadata.impl.TnBeanMetaDataImpl;
import org.seasar.dbflute.s2dao.metadata.impl.TnPropertyTypeFactoryBuilderImpl;
import org.seasar.dbflute.s2dao.metadata.impl.TnRelationPropertyTypeFactoryBuilderImpl;

public abstract class TnBeanMetaDataFactoryImpl
implements TnBeanMetaDataFactory {
    protected static final String MODIFIED_PROPERTY_PROPERTY_NAME = "modifiedPropertyNames";
    protected DataSource _dataSource;

    @Override
    public TnBeanMetaData createBeanMetaData(Class<?> beanClass) {
        return this.createBeanMetaData(beanClass, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TnBeanMetaData createBeanMetaData(Class<?> beanClass, int relationNestLevel) {
        if (beanClass == null) {
            throw new IllegalArgumentException("The argument 'beanClass' should not be null.");
        }
        LazyDatabaseMetaDataWrapper metaDataWrapper = this.createLazyDatabaseMetaDataWrapper(beanClass);
        try {
            TnBeanMetaData tnBeanMetaData = this.createBeanMetaData(metaDataWrapper, beanClass, relationNestLevel);
            return tnBeanMetaData;
        }
        finally {
            try {
                metaDataWrapper.closeActualReally();
            }
            catch (SQLException e) {
                SQLExceptionResource resource = this.createSQLExceptionResource();
                resource.setNotice("Failed to close the database connection.");
                this.handleSQLException(e, resource);
            }
        }
    }

    protected abstract LazyDatabaseMetaDataWrapper createLazyDatabaseMetaDataWrapper(Class<?> var1);

    protected void handleSQLException(SQLException e, SQLExceptionResource resource) {
        this.createSQLExceptionHandler().handleSQLException(e, resource);
    }

    protected SQLExceptionHandler createSQLExceptionHandler() {
        return ResourceContext.createSQLExceptionHandler();
    }

    protected SQLExceptionResource createSQLExceptionResource() {
        return new SQLExceptionResource();
    }

    @Override
    public TnBeanMetaData createBeanMetaData(DatabaseMetaData dbMetaData, Class<?> beanClass, int relationNestLevel) {
        if (dbMetaData == null) {
            throw new IllegalArgumentException("The argument 'dbMetaData' should not be null.");
        }
        if (beanClass == null) {
            throw new IllegalArgumentException("The argument 'beanClass' should not be null.");
        }
        TnBeanMetaDataImpl bmd = this.createBeanMetaDataImpl(beanClass);
        TnBeanAnnotationReader beanAnnotationReader = this.createBeanAnnotationReader(beanClass);
        String versionNoPropertyName = this.getVersionNoPropertyName(beanAnnotationReader);
        String timestampPropertyName = this.getTimestampPropertyName(beanAnnotationReader);
        bmd.setBeanAnnotationReader(beanAnnotationReader);
        bmd.setVersionNoPropertyName(versionNoPropertyName);
        bmd.setTimestampPropertyName(timestampPropertyName);
        bmd.setPropertyTypeFactory(this.createPropertyTypeFactory(beanClass, beanAnnotationReader, dbMetaData));
        boolean stopRelationCreation = this.isLimitRelationNestLevel(relationNestLevel);
        bmd.setRelationPropertyTypeFactory(this.createRelationPropertyTypeFactory(beanClass, bmd, beanAnnotationReader, dbMetaData, relationNestLevel, stopRelationCreation));
        bmd.setModifiedPropertySupport(this.createModifiedPropertySupport());
        bmd.initialize();
        return bmd;
    }

    protected abstract TnBeanMetaDataImpl createBeanMetaDataImpl(Class<?> var1);

    protected abstract TnModifiedPropertySupport createModifiedPropertySupport();

    protected abstract TnBeanAnnotationReader createBeanAnnotationReader(Class<?> var1);

    protected String getVersionNoPropertyName(TnBeanAnnotationReader beanAnnotationReader) {
        String defaultName = "versionNo";
        String name = beanAnnotationReader.getVersionNoPropertyName();
        return name != null ? name : "versionNo";
    }

    protected String getTimestampPropertyName(TnBeanAnnotationReader beanAnnotationReader) {
        return beanAnnotationReader.getTimestampPropertyName();
    }

    protected TnPropertyTypeFactory createPropertyTypeFactory(Class<?> beanClass, TnBeanAnnotationReader beanAnnotationReader, DatabaseMetaData dbMetaData) {
        return this.createPropertyTypeFactoryBuilder(dbMetaData).build(beanClass, beanAnnotationReader);
    }

    protected TnPropertyTypeFactoryBuilder createPropertyTypeFactoryBuilder(DatabaseMetaData dbMetaData) {
        return new TnPropertyTypeFactoryBuilderImpl();
    }

    protected TnRelationPropertyTypeFactory createRelationPropertyTypeFactory(Class<?> beanClass, TnBeanMetaDataImpl localBeanMetaData, TnBeanAnnotationReader beanAnnotationReader, DatabaseMetaData dbMetaData, int relationNestLevel, boolean stopRelationCreation) {
        TnRelationPropertyTypeFactoryBuilder builder = this.createRelationPropertyTypeFactoryBuilder();
        return builder.build(beanClass, localBeanMetaData, beanAnnotationReader, dbMetaData, relationNestLevel, stopRelationCreation);
    }

    protected TnRelationPropertyTypeFactoryBuilder createRelationPropertyTypeFactoryBuilder() {
        return new TnRelationPropertyTypeFactoryBuilderImpl(this);
    }

    protected boolean isLimitRelationNestLevel(int relationNestLevel) {
        return relationNestLevel == this.getLimitRelationNestLevel();
    }

    protected abstract int getLimitRelationNestLevel();

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }
}

