/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.s2dao.extension;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.exception.MappingClassCastException;
import org.seasar.dbflute.jdbc.ValueType;
import org.seasar.dbflute.resource.DBFluteSystem;
import org.seasar.dbflute.resource.InternalMapContext;
import org.seasar.dbflute.resource.ResourceContext;
import org.seasar.dbflute.s2dao.metadata.TnBeanMetaData;
import org.seasar.dbflute.s2dao.metadata.TnPropertyMapping;
import org.seasar.dbflute.s2dao.rowcreator.impl.TnRowCreatorImpl;
import org.seasar.dbflute.util.DfTypeUtil;

public class TnRowCreatorExtension
extends TnRowCreatorImpl {
    private static final Log _log = LogFactory.getLog(TnRowCreatorExtension.class);
    protected static final String DBMETA_CACHE_KEY = "df:DBMetaCache";
    protected DBMeta _fixedDBMeta;
    protected boolean _creatableByDBMeta;

    protected TnRowCreatorExtension() {
    }

    public static TnRowCreatorExtension createRowCreator(Class<?> beanClass) {
        DBMeta dbmeta;
        TnRowCreatorExtension rowCreator = new TnRowCreatorExtension();
        if (beanClass != null && (dbmeta = TnRowCreatorExtension.findDBMetaByClass(beanClass)) != null) {
            rowCreator.setFixedDBMeta(dbmeta);
            rowCreator.setCreatableByDBMeta(TnRowCreatorExtension.isCreatableByDBMeta(beanClass, dbmeta.getEntityType()));
        }
        return rowCreator;
    }

    protected static DBMeta findDBMetaByClass(Class<?> beanClass) {
        if (!Entity.class.isAssignableFrom(beanClass)) {
            return null;
        }
        Object instance = TnRowCreatorExtension.newInstance(beanClass);
        return ((Entity)instance).getDBMeta();
    }

    protected static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static boolean isCreatableByDBMeta(Class<?> beanClass, Class<?> entityType) {
        return beanClass.isAssignableFrom(entityType);
    }

    @Override
    public Object createRow(ResultSet rs, Map<String, Integer> selectIndexMap, Map<String, TnPropertyMapping> propertyCache, Class<?> beanClass) throws SQLException {
        DBMeta dbmeta;
        Object row;
        if (propertyCache.isEmpty()) {
            String msg = "The propertyCache should not be empty: bean=" + beanClass.getName();
            throw new IllegalStateException(msg);
        }
        String columnName = null;
        TnPropertyMapping mapping = null;
        String propertyName = null;
        Object selectedValue = null;
        if (this._fixedDBMeta != null) {
            row = this._creatableByDBMeta ? this._fixedDBMeta.newEntity() : this.newBean(beanClass);
            dbmeta = this._fixedDBMeta;
        } else {
            row = this.newBean(beanClass);
            dbmeta = TnRowCreatorExtension.findCachedDBMeta(row);
        }
        try {
            if (dbmeta != null) {
                for (Map.Entry<String, TnPropertyMapping> entry : propertyCache.entrySet()) {
                    columnName = entry.getKey();
                    mapping = entry.getValue();
                    propertyName = mapping.getPropertyName();
                    selectedValue = this.getValue(rs, columnName, mapping.getValueType(), selectIndexMap);
                    ColumnInfo columnInfo = mapping.getEntityColumnInfo();
                    if (columnInfo != null) {
                        columnInfo.write((Entity)row, selectedValue);
                        continue;
                    }
                    mapping.getPropertyAccessor().setValue(row, selectedValue);
                }
            } else {
                for (Map.Entry<String, TnPropertyMapping> entry : propertyCache.entrySet()) {
                    columnName = entry.getKey();
                    mapping = entry.getValue();
                    propertyName = mapping.getPropertyName();
                    selectedValue = this.getValue(rs, columnName, mapping.getValueType(), selectIndexMap);
                    mapping.getPropertyAccessor().setValue(row, selectedValue);
                }
            }
            return row;
        }
        catch (ClassCastException e) {
            this.throwMappingClassCastException(row, dbmeta, mapping, selectedValue, e);
            return null;
        }
        catch (SQLException e) {
            if (_log.isDebugEnabled()) {
                String msg = "Failed to get selected values while resultSet handling:";
                msg = msg + " target=" + DfTypeUtil.toClassTitle(beanClass) + "." + propertyName;
                _log.debug((Object)msg);
            }
            throw e;
        }
    }

    protected Object getValue(ResultSet rs, String columnName, ValueType valueType, Map<String, Integer> selectIndexMap) throws SQLException {
        Object value = selectIndexMap != null ? ResourceContext.getValue(rs, columnName, valueType, selectIndexMap) : valueType.getValue(rs, columnName);
        return value;
    }

    protected void throwMappingClassCastException(Object entity, DBMeta dbmeta, TnPropertyMapping mapping, Object selectedValue, ClassCastException e) {
        String msg = "Look! Read the message below." + this.ln();
        msg = msg + "/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *" + this.ln();
        msg = msg + "Failed to cast a class while data mapping!" + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Advice]" + this.ln();
        msg = msg + "If you use Seasar(S2Container), this exception may be" + this.ln();
        msg = msg + "from ClassLoader Headache about HotDeploy." + this.ln();
        msg = msg + "Add the ignore-package setting to convention.dicon like this:" + this.ln();
        msg = msg + "  For example:" + this.ln();
        msg = msg + "    <initMethod name=\u201daddIgnorePackageName\u201d>" + this.ln();
        msg = msg + "        <arg>\u201dcom.example.xxx.dbflute\u201d</arg>" + this.ln();
        msg = msg + "    </initMethod>" + this.ln();
        msg = msg + "If you use an other DI container, this exception may be" + this.ln();
        msg = msg + "from illegal state about your settings of DBFlute." + this.ln();
        msg = msg + "Confirm your settings: for example, typeMappingMap.dfprop." + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Exception Message]" + this.ln() + e.getMessage() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target Entity]" + this.ln() + entity + this.ln();
        msg = msg + "classLoader: " + entity.getClass().getClassLoader() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Target DBMeta]" + this.ln() + dbmeta + this.ln();
        msg = msg + "classLoader: " + dbmeta.getClass().getClassLoader() + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Property Mapping]" + this.ln() + mapping + this.ln();
        msg = msg + "type: " + (mapping != null ? mapping.getClass() : null) + this.ln();
        msg = msg + this.ln();
        msg = msg + "[Selected Value]" + this.ln() + selectedValue + this.ln();
        msg = msg + "type: " + (selectedValue != null ? selectedValue.getClass() : null) + this.ln();
        msg = msg + "* * * * * * * * * */";
        throw new MappingClassCastException(msg, e);
    }

    public static DBMeta findCachedDBMeta(Object row) {
        return DBMetaCacheHandler.findDBMeta(row);
    }

    public static DBMeta findCachedDBMeta(Class<?> rowType, String tableName) {
        return DBMetaCacheHandler.findDBMeta(rowType, tableName);
    }

    public static void adjustCreatedRow(Object row, TnBeanMetaData bmd) {
        if (row instanceof Entity) {
            ((Entity)row).clearModifiedInfo();
        } else {
            bmd.getModifiedPropertyNames(row).clear();
        }
    }

    protected String ln() {
        return DBFluteSystem.getBasicLn();
    }

    public void setFixedDBMeta(DBMeta fixedDBMeta) {
        this._fixedDBMeta = fixedDBMeta;
    }

    public void setCreatableByDBMeta(boolean creatableByDBMeta) {
        this._creatableByDBMeta = creatableByDBMeta;
    }

    protected static class DBMetaCacheHandler {
        protected static final String DBMETA_CACHE_KEY = "df:DBMetaCache";

        protected DBMetaCacheHandler() {
        }

        public static DBMeta findDBMeta(Object row) {
            if (!(row instanceof Entity)) {
                return null;
            }
            Entity entity = (Entity)row;
            DBMeta dbmeta = DBMetaCacheHandler.getCachedDBMeta(entity.getClass());
            if (dbmeta != null) {
                return dbmeta;
            }
            dbmeta = entity.getDBMeta();
            DBMetaCacheHandler.cacheDBMeta(entity, dbmeta);
            return dbmeta;
        }

        public static DBMeta findDBMeta(Class<?> rowType, String tableName) {
            DBMeta dbmeta = DBMetaCacheHandler.getCachedDBMeta(rowType);
            if (dbmeta != null) {
                return dbmeta;
            }
            dbmeta = ResourceContext.provideDBMeta(tableName);
            DBMetaCacheHandler.cacheDBMeta(rowType, dbmeta);
            return dbmeta;
        }

        protected static DBMeta getCachedDBMeta(Class<?> rowType) {
            Map<Class<?>, DBMeta> contextCacheMap = DBMetaCacheHandler.getDBMetaContextCacheMap();
            if (contextCacheMap == null) {
                contextCacheMap = new HashMap();
                InternalMapContext.setObject("df:DBMetaCache", contextCacheMap);
            }
            return contextCacheMap.get(rowType);
        }

        protected static void cacheDBMeta(Entity entity, DBMeta dbmeta) {
            DBMetaCacheHandler.cacheDBMeta(entity.getClass(), dbmeta);
        }

        protected static void cacheDBMeta(Class<?> type, DBMeta dbmeta) {
            Map<Class<?>, DBMeta> dbmetaCache = DBMetaCacheHandler.getDBMetaContextCacheMap();
            dbmetaCache.put(type, dbmeta);
        }

        protected static Map<Class<?>, DBMeta> getDBMetaContextCacheMap() {
            return (Map)InternalMapContext.getObject("df:DBMetaCache");
        }
    }
}

