/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.dbmeta.alter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.dbmeta.alter.AlterGenerator;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;

public abstract class AbstractAlterGenerator
implements AlterGenerator {
    protected void doBuildAlterTable(StringBuilder sb, DBMeta dbmeta) {
        this.doBuildAlterTable(sb, dbmeta.getTableSqlName().toString());
    }

    protected void doBuildAlterTable(StringBuilder sb, String tableName) {
        sb.append("alter table ").append(tableName);
    }

    public List<String> packForeignAddList(Collection<DBMeta> dbmetaList) {
        ArrayList<String> ddlList = new ArrayList<String>();
        for (DBMeta dbmeta : dbmetaList) {
            List<ForeignInfo> foreignInfoList = dbmeta.getForeignInfoList();
            for (ForeignInfo info : foreignInfoList) {
                if (!info.isPureFK()) continue;
                ddlList.add(this.generateForeignKeyAdd(info));
            }
        }
        return ddlList;
    }

    public List<String> packForeignDropList(Collection<DBMeta> dbmetaList) {
        ArrayList<String> ddlList = new ArrayList<String>();
        for (DBMeta dbmeta : dbmetaList) {
            List<ForeignInfo> foreignInfoList = dbmeta.getForeignInfoList();
            for (ForeignInfo info : foreignInfoList) {
                if (!info.isPureFK()) continue;
                ddlList.add(this.generateForeignKeyDrop(info));
            }
        }
        return ddlList;
    }
}

