/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.coption;

import java.util.List;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.cbean.chelper.HpCalcSpecification;
import org.seasar.dbflute.cbean.chelper.HpCalculator;
import org.seasar.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.seasar.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.dbflute.cbean.ckey.ConditionKey;
import org.seasar.dbflute.cbean.coption.ColumnConversionOption;
import org.seasar.dbflute.cbean.coption.ConditionOption;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbway.ExtensionOperand;
import org.seasar.dbflute.dbway.StringConnector;
import org.seasar.dbflute.exception.IllegalConditionBeanOperationException;
import org.seasar.dbflute.util.DfCollectionUtil;
import org.seasar.dbflute.util.DfTypeUtil;

public class RangeOfOption
implements ConditionOption,
HpCalculator {
    protected boolean _greaterThan;
    protected boolean _lessThan;
    protected boolean _orIsNull;
    protected HpCalcSpecification<ConditionBean> _calcSpecification;

    public RangeOfOption greaterThan() {
        this._greaterThan = true;
        return this;
    }

    public RangeOfOption lessThan() {
        this._lessThan = true;
        return this;
    }

    protected void clearOperand() {
        this._greaterThan = false;
        this._lessThan = false;
    }

    public RangeOfOption orIsNull() {
        this._orIsNull = true;
        return this;
    }

    public ConditionKey getMinNumberConditionKey() {
        if (this._greaterThan) {
            return this._orIsNull ? ConditionKey.CK_GREATER_THAN_OR_IS_NULL : ConditionKey.CK_GREATER_THAN;
        }
        return this._orIsNull ? ConditionKey.CK_GREATER_EQUAL_OR_IS_NULL : ConditionKey.CK_GREATER_EQUAL;
    }

    public ConditionKey getMaxNumberConditionKey() {
        if (this._lessThan) {
            return this._orIsNull ? ConditionKey.CK_LESS_THAN_OR_IS_NULL : ConditionKey.CK_LESS_THAN;
        }
        return this._orIsNull ? ConditionKey.CK_LESS_EQUAL_OR_IS_NULL : ConditionKey.CK_LESS_EQUAL;
    }

    @Override
    public HpCalculator plus(Number plusValue) {
        this.assertObjectNotNull("plusValue", plusValue);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.plus(plusValue);
    }

    @Override
    public HpCalculator plus(HpSpecifiedColumn plusColumn) {
        this.assertObjectNotNull("plusColumn", plusColumn);
        this.assertCalculationColumnNumber(plusColumn);
        this.assertSpecifiedDreamCruiseTicket(plusColumn);
        this.initializeCalcSpecificationIfNeeds();
        this.setupSelectDreamCruiseJourneyLogBookIfUnionExists(plusColumn);
        return this._calcSpecification.plus(plusColumn);
    }

    @Override
    public HpCalculator minus(Number minusValue) {
        this.assertObjectNotNull("minusValue", minusValue);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.minus(minusValue);
    }

    @Override
    public HpCalculator minus(HpSpecifiedColumn minusColumn) {
        this.assertObjectNotNull("minusColumn", minusColumn);
        this.assertCalculationColumnNumber(minusColumn);
        this.assertSpecifiedDreamCruiseTicket(minusColumn);
        this.initializeCalcSpecificationIfNeeds();
        this.setupSelectDreamCruiseJourneyLogBookIfUnionExists(minusColumn);
        return this._calcSpecification.minus(minusColumn);
    }

    @Override
    public HpCalculator multiply(Number multiplyValue) {
        this.assertObjectNotNull("multiplyValue", multiplyValue);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.multiply(multiplyValue);
    }

    @Override
    public HpCalculator multiply(HpSpecifiedColumn multiplyColumn) {
        this.assertObjectNotNull("multiplyColumn", multiplyColumn);
        this.assertCalculationColumnNumber(multiplyColumn);
        this.assertSpecifiedDreamCruiseTicket(multiplyColumn);
        this.initializeCalcSpecificationIfNeeds();
        this.setupSelectDreamCruiseJourneyLogBookIfUnionExists(multiplyColumn);
        return this._calcSpecification.multiply(multiplyColumn);
    }

    @Override
    public HpCalculator divide(Number divideValue) {
        this.assertObjectNotNull("divideValue", divideValue);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.divide(divideValue);
    }

    @Override
    public HpCalculator divide(HpSpecifiedColumn divideColumn) {
        this.assertObjectNotNull("divideColumn", divideColumn);
        this.assertCalculationColumnNumber(divideColumn);
        this.assertSpecifiedDreamCruiseTicket(divideColumn);
        this.initializeCalcSpecificationIfNeeds();
        this.setupSelectDreamCruiseJourneyLogBookIfUnionExists(divideColumn);
        return this._calcSpecification.divide(divideColumn);
    }

    @Override
    public HpCalculator convert(ColumnConversionOption option) {
        this.assertObjectNotNull("option", option);
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.convert(option);
    }

    @Override
    public HpCalculator left() {
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.left();
    }

    @Override
    public HpCalculator right() {
        this.initializeCalcSpecificationIfNeeds();
        return this._calcSpecification.right();
    }

    protected void initializeCalcSpecificationIfNeeds() {
        if (this._calcSpecification == null) {
            this._calcSpecification = this.createCalcSpecification();
        }
    }

    protected void setupSelectDreamCruiseJourneyLogBookIfUnionExists(HpSpecifiedColumn column) {
        column.setupSelectDreamCruiseJourneyLogBookIfUnionExists();
    }

    protected HpCalcSpecification<ConditionBean> createCalcSpecification() {
        return new HpCalcSpecification<ConditionBean>(this.createEmptySpecifyQuery());
    }

    protected SpecifyQuery<ConditionBean> createEmptySpecifyQuery() {
        return new SpecifyQuery<ConditionBean>(){

            @Override
            public void specify(ConditionBean cb) {
            }
        };
    }

    public boolean hasCalculationRange() {
        return this._calcSpecification != null;
    }

    public HpCalcSpecification<ConditionBean> getCalculationRange() {
        return this._calcSpecification;
    }

    public void xinitCalculationRange(ConditionBean baseCB, ConditionBean dreamCruiseCB) {
        if (!dreamCruiseCB.xisDreamCruiseShip()) {
            String msg = "The CB was not dream cruise: " + dreamCruiseCB.getClass();
            throw new IllegalConditionBeanOperationException(msg);
        }
        this._calcSpecification.setBaseCB(baseCB);
        this._calcSpecification.specify(dreamCruiseCB);
    }

    @Override
    public String getRearOption() {
        return "";
    }

    @Override
    public boolean hasCompoundColumn() {
        return false;
    }

    @Override
    public List<HpSpecifiedColumn> getCompoundColumnList() {
        return DfCollectionUtil.emptyList();
    }

    @Override
    public boolean hasStringConnector() {
        return false;
    }

    @Override
    public StringConnector getStringConnector() {
        return null;
    }

    @Override
    public ExtensionOperand getExtensionOperand() {
        return null;
    }

    @Override
    public QueryClauseArranger getWhereClauseArranger() {
        return null;
    }

    @Override
    public GearedCipherManager getGearedCipherManager() {
        return null;
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertCalculationColumnNumber(HpSpecifiedColumn specifiedColumn) {
        ColumnInfo columnInfo = specifiedColumn.getColumnInfo();
        if (columnInfo == null) {
            return;
        }
        if (!columnInfo.isPropertyTypeNumber()) {
            String msg = "The type of the calculation column should be Number: " + specifiedColumn;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertSpecifiedDreamCruiseTicket(HpSpecifiedColumn column) {
        if (!column.isDreamCruiseTicket()) {
            String msg = "The specified column was not dream cruise ticket: " + column;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append(":{greaterThan=").append(this._greaterThan).append(", lessThan=").append(this._lessThan);
        sb.append(", orIsNull=").append(this._orIsNull).append("}");
        return sb.toString();
    }
}

