/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dbflute.cbean.coption;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.seasar.dbflute.cbean.chelper.HpSpecifiedColumn;
import org.seasar.dbflute.cbean.cipher.GearedCipherManager;
import org.seasar.dbflute.cbean.coption.SimpleStringOption;
import org.seasar.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.seasar.dbflute.dbway.ExtensionOperand;
import org.seasar.dbflute.dbway.StringConnector;
import org.seasar.dbflute.util.DfTypeUtil;

public class LikeSearchOption
extends SimpleStringOption {
    protected static final String LIKE_PREFIX = "prefix";
    protected static final String LIKE_SUFFIX = "suffix";
    protected static final String LIKE_CONTAIN = "contain";
    protected String _like;
    protected String _escape;
    protected boolean _asOrSplit;
    protected List<String> _originalWildCardList;
    protected List<HpSpecifiedColumn> _compoundColumnList;
    protected List<Integer> _compoundColumnSizeList;
    protected StringConnector _stringConnector;
    protected GearedCipherManager _cipherManager;

    @Override
    public String getRearOption() {
        if (this._escape == null || this._escape.trim().length() == 0) {
            return "";
        }
        return " escape '" + this._escape + "'";
    }

    public LikeSearchOption likePrefix() {
        this._like = LIKE_PREFIX;
        this.doLikeAutoEscape();
        return this;
    }

    public LikeSearchOption likeSuffix() {
        this._like = LIKE_SUFFIX;
        this.doLikeAutoEscape();
        return this;
    }

    public LikeSearchOption likeContain() {
        this._like = LIKE_CONTAIN;
        this.doLikeAutoEscape();
        return this;
    }

    protected void doLikeAutoEscape() {
        this.escape();
    }

    public boolean isLikePrefix() {
        return LIKE_PREFIX.equals(this._like);
    }

    public boolean isLikeSuffix() {
        return LIKE_SUFFIX.equals(this._like);
    }

    public boolean isLikeContain() {
        return LIKE_CONTAIN.equals(this._like);
    }

    public LikeSearchOption escape() {
        return this.escapeByPipeLine();
    }

    public LikeSearchOption escapeByPipeLine() {
        this._escape = "|";
        return this;
    }

    public LikeSearchOption escapeByAtMark() {
        this._escape = "@";
        return this;
    }

    public LikeSearchOption escapeBySlash() {
        this._escape = "/";
        return this;
    }

    public LikeSearchOption escapeByBackSlash() {
        this._escape = "\\";
        return this;
    }

    public LikeSearchOption notEscape() {
        this._escape = null;
        return this;
    }

    public LikeSearchOption splitByBlank() {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitByBlank();
    }

    public LikeSearchOption splitByBlank(int splitLimitCount) {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitByBlank(splitLimitCount);
    }

    public LikeSearchOption splitBySpace() {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitBySpace();
    }

    public LikeSearchOption splitBySpace(int splitLimitCount) {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitBySpace(splitLimitCount);
    }

    public LikeSearchOption splitBySpaceContainsDoubleByte() {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitBySpaceContainsDoubleByte();
    }

    public LikeSearchOption splitBySpaceContainsDoubleByte(int splitLimitCount) {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitBySpaceContainsDoubleByte(splitLimitCount);
    }

    public LikeSearchOption splitByPipeLine() {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitByPipeLine();
    }

    public LikeSearchOption splitByPipeLine(int splitLimitCount) {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitByPipeLine(splitLimitCount);
    }

    public LikeSearchOption splitByVarious(List<String> delimiterList) {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitByVarious(delimiterList);
    }

    public LikeSearchOption splitByVarious(List<String> delimiterList, int splitLimitCount) {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitByVarious(delimiterList, splitLimitCount);
    }

    protected void assertSplitByPrecondition() {
        if (this.hasCompoundColumn()) {
            String msg = "The Split of LikeSearch is unsupported with CompoundColumn.";
            throw new IllegalStateException(msg);
        }
    }

    public LikeSearchOption asOrSplit() {
        this._asOrSplit = true;
        return this;
    }

    public boolean isAsOrSplit() {
        return this._asOrSplit;
    }

    public LikeSearchOption addCompoundColumn(HpSpecifiedColumn compoundColumn) {
        this.assertCompoundColumnPrecondition(compoundColumn);
        this.assertCompoundColumnSpecifiedColumn(compoundColumn);
        if (this._compoundColumnList == null) {
            this._compoundColumnList = new ArrayList<HpSpecifiedColumn>();
        }
        this._compoundColumnList.add(compoundColumn);
        return this;
    }

    protected void assertCompoundColumnPrecondition(HpSpecifiedColumn compoundColumn) {
        if (this.isSplit()) {
            String msg = "The CompoundColumn of LikeSearch is unsupported with Split: " + compoundColumn;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertCompoundColumnSpecifiedColumn(HpSpecifiedColumn compoundColumn) {
        if (compoundColumn == null) {
            String msg = "The argument 'compoundColumn' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (!compoundColumn.getColumnInfo().isPropertyTypeString()) {
            String msg = "The type of the compound column should be String: " + compoundColumn;
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public boolean hasCompoundColumn() {
        return this._compoundColumnList != null && !this._compoundColumnList.isEmpty();
    }

    @Override
    public List<HpSpecifiedColumn> getCompoundColumnList() {
        return this._compoundColumnList;
    }

    public void clearCompoundColumn() {
        if (this._compoundColumnList != null) {
            this._compoundColumnList.clear();
        }
        if (this._compoundColumnSizeList != null) {
            this._compoundColumnSizeList.clear();
        }
    }

    public LikeSearchOption optimizeCompoundColumnByFixedSize(Integer ... sizes) {
        if (!this.hasCompoundColumn()) {
            String msg = "The CompoundColumnOptimization needs CompoundColumn.";
            throw new IllegalStateException(msg);
        }
        if (sizes.length > this._compoundColumnList.size() + 1) {
            String msg = "The length of argument 'sizes' should be less or equal count of compound columns + 1.";
            msg = msg + " sizes.length=" + sizes.length;
            msg = msg + " compoundColumnList.size()=" + this._compoundColumnList.size();
            throw new IllegalArgumentException(msg);
        }
        this._compoundColumnSizeList = Arrays.asList(sizes);
        return this;
    }

    public boolean canOptimizeCompoundColumnLikePrefix() {
        return this.hasCompoundColumn() && this.hasCompoundColumnOptimization() && this.isLikePrefix();
    }

    public boolean hasCompoundColumnOptimization() {
        return this._compoundColumnSizeList != null && !this._compoundColumnSizeList.isEmpty();
    }

    public List<Integer> getCompoundColumnSizeList() {
        return this._compoundColumnSizeList;
    }

    public LikeSearchOption acceptStringConnector(StringConnector stringConnector) {
        this._stringConnector = stringConnector;
        return this;
    }

    @Override
    public boolean hasStringConnector() {
        return this._stringConnector != null;
    }

    @Override
    public StringConnector getStringConnector() {
        return this._stringConnector;
    }

    @Override
    public String generateRealValue(String value) {
        value = super.generateRealValue(value);
        if (this._escape != null && this._escape.trim().length() != 0) {
            String tmp = this.replace(value, this._escape, this._escape + this._escape);
            tmp = this.filterEscape(tmp, "%");
            tmp = this.filterEscape(tmp, "_");
            if (this._originalWildCardList != null) {
                for (String wildCard : this._originalWildCardList) {
                    tmp = this.filterEscape(tmp, wildCard);
                }
            }
            value = tmp;
        }
        String wildCard = "%";
        if (this._like == null || this._like.trim().length() == 0) {
            return value;
        }
        if (this._like.equals(LIKE_PREFIX)) {
            return value + "%";
        }
        if (this._like.equals(LIKE_SUFFIX)) {
            return "%" + value;
        }
        if (this._like.equals(LIKE_CONTAIN)) {
            return "%" + value + "%";
        }
        String msg = "The like was wrong string: " + this._like;
        throw new IllegalStateException(msg);
    }

    protected String filterEscape(String target, String wildCard) {
        return this.replace(target, wildCard, this._escape + wildCard);
    }

    public LikeSearchOption acceptOriginalWildCardList(List<String> originalWildCardList) {
        this._originalWildCardList = originalWildCardList;
        return this;
    }

    @Override
    public LikeSearchOption createDeepCopy() {
        LikeSearchOption copy = (LikeSearchOption)super.createDeepCopy();
        copy._like = this._like;
        copy._escape = this._escape;
        copy._asOrSplit = this._asOrSplit;
        if (this._originalWildCardList != null) {
            copy._originalWildCardList = new ArrayList<String>(this._originalWildCardList);
        }
        if (this._compoundColumnList != null) {
            copy._compoundColumnList = new ArrayList<HpSpecifiedColumn>(this._compoundColumnList);
        }
        if (this._compoundColumnSizeList != null) {
            copy._compoundColumnSizeList = new ArrayList<Integer>(this._compoundColumnSizeList);
        }
        copy._stringConnector = this._stringConnector;
        return copy;
    }

    @Override
    protected LikeSearchOption newDeepCopyInstance() {
        return new LikeSearchOption();
    }

    @Override
    public ExtensionOperand getExtensionOperand() {
        return null;
    }

    @Override
    public QueryClauseArranger getWhereClauseArranger() {
        return null;
    }

    public void acceptGearedCipherManager(GearedCipherManager cipherManager) {
        this._cipherManager = cipherManager;
    }

    @Override
    public GearedCipherManager getGearedCipherManager() {
        return this._cipherManager;
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        String split = this.isSplit() ? (this._asOrSplit ? "true(or)" : "true(and)") : "false";
        return title + ":{like=" + this._like + ", escape=" + this._escape + ", split=" + split + "}";
    }
}

