/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events.aggregated;

import com.carrotsearch.ant.tasks.junit4.SlaveInfo;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedTestResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.TestStatus;
import com.carrotsearch.ant.tasks.junit4.events.mirrors.FailureMirror;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;

public class AggregatedSuiteResultEvent
implements AggregatedResultEvent {
    private final transient SlaveInfo slave;
    private final long executionTime;
    private final long startTimestamp;
    private final Description description;
    private final List tests;
    private final List suiteFailures;
    private final List eventStream;

    public AggregatedSuiteResultEvent(SlaveInfo slaveInfo, Description description, List list, List list2, List list3, long l, long l2) {
        this.slave = slaveInfo;
        this.tests = list2;
        this.suiteFailures = list;
        this.description = description;
        this.eventStream = list3;
        this.executionTime = l2;
        this.startTimestamp = l;
    }

    public List getTests() {
        return this.tests;
    }

    @Override
    public List getFailures() {
        return Collections.unmodifiableList(this.suiteFailures);
    }

    @Override
    public boolean isSuccessful() {
        if (!this.suiteFailures.isEmpty()) {
            return false;
        }
        for (AggregatedTestResultEvent aggregatedTestResultEvent : this.tests) {
            if (aggregatedTestResultEvent.isSuccessful()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getEventStream() {
        return this.eventStream;
    }

    @Override
    public SlaveInfo getSlave() {
        return this.slave;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public int getFailureCount() {
        int n = 0;
        for (Object object : this.getTests()) {
            if (((AggregatedTestResultEvent)object).getStatus() != TestStatus.FAILURE) continue;
            ++n;
        }
        for (Object object : this.getFailures()) {
            if (!((FailureMirror)object).isAssertionViolation()) continue;
            ++n;
        }
        return n;
    }

    public int getErrorCount() {
        int n = 0;
        for (Object object : this.getTests()) {
            if (((AggregatedTestResultEvent)object).getStatus() != TestStatus.ERROR) continue;
            ++n;
        }
        for (Object object : this.getFailures()) {
            if (!((FailureMirror)object).isErrorViolation()) continue;
            ++n;
        }
        return n;
    }

    public int getIgnoredCount() {
        int n = 0;
        for (AggregatedTestResultEvent aggregatedTestResultEvent : this.getTests()) {
            if (aggregatedTestResultEvent.getStatus() != TestStatus.IGNORED && aggregatedTestResultEvent.getStatus() != TestStatus.IGNORED_ASSUMPTION) continue;
            ++n;
        }
        return n;
    }
}

