/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Collections2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ObjectArrays;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableListIterator;
import java.util.List;
import javax.annotation.Nullable;

class RegularImmutableList
extends ImmutableList {
    private final transient int offset;
    private final transient int size;
    private final transient Object[] array;

    RegularImmutableList(Object[] objectArray, int n, int n2) {
        this.offset = n;
        this.size = n2;
        this.array = objectArray;
    }

    RegularImmutableList(Object[] objectArray) {
        this(objectArray, 0, objectArray.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    boolean isPartialView() {
        return this.offset != 0 || this.size != this.array.length;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        System.arraycopy(this.array, this.offset, objectArray, 0, this.size);
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = ObjectArrays.newArray(objectArray, this.size);
        } else if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        System.arraycopy(this.array, this.offset, objectArray, 0, this.size);
        return objectArray;
    }

    public Object get(int n) {
        Preconditions.checkElementIndex(n, this.size);
        return this.array[n + this.offset];
    }

    @Override
    ImmutableList subListUnchecked(int n, int n2) {
        return new RegularImmutableList(this.array, this.offset + n, n2 - n);
    }

    @Override
    public UnmodifiableListIterator listIterator(int n) {
        return Iterators.forArray(this.array, this.offset, this.size, n);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        int n = this.offset;
        if (object instanceof RegularImmutableList) {
            RegularImmutableList regularImmutableList = (RegularImmutableList)object;
            for (int i = regularImmutableList.offset; i < regularImmutableList.offset + regularImmutableList.size; ++i) {
                if (this.array[n++].equals(regularImmutableList.array[i])) continue;
                return false;
            }
        } else {
            for (Object e : list) {
                if (this.array[n++].equals(e)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(this.size()).append('[').append(this.array[this.offset]);
        for (int i = this.offset + 1; i < this.offset + this.size; ++i) {
            stringBuilder.append(", ").append(this.array[i]);
        }
        return stringBuilder.append(']').toString();
    }
}

