/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Collections2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;

public final class Lists {
    public static ArrayList newArrayList() {
        return new ArrayList();
    }

    public static ArrayList newArrayList(Iterable iterable) {
        Preconditions.checkNotNull(iterable);
        return iterable instanceof Collection ? new ArrayList(Collections2.cast(iterable)) : Lists.newArrayList(iterable.iterator());
    }

    public static ArrayList newArrayList(Iterator iterator) {
        Preconditions.checkNotNull(iterator);
        ArrayList arrayList = Lists.newArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public static ArrayList newArrayListWithCapacity(int n) {
        Preconditions.checkArgument(n >= 0);
        return new ArrayList(n);
    }

    public static LinkedList newLinkedList() {
        return new LinkedList();
    }

    static int hashCodeImpl(List list) {
        int n = 1;
        for (Object e : list) {
            n = 31 * n + (e == null ? 0 : e.hashCode());
            n = ~(~n);
        }
        return n;
    }

    static boolean equalsImpl(List list, @Nullable Object object) {
        if (object == Preconditions.checkNotNull(list)) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list2 = (List)object;
        return list.size() == list2.size() && Iterators.elementsEqual(list.iterator(), list2.iterator());
    }

    static int indexOfImpl(List list, @Nullable Object object) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (!Objects.equal(object, listIterator.next())) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    static int lastIndexOfImpl(List list, @Nullable Object object) {
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            if (!Objects.equal(object, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }
}

