/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4;

import com.carrotsearch.ant.tasks.junit4.BalancersList;
import com.carrotsearch.ant.tasks.junit4.DiagnosticsListener;
import com.carrotsearch.ant.tasks.junit4.Duration;
import com.carrotsearch.ant.tasks.junit4.JUnit4$1;
import com.carrotsearch.ant.tasks.junit4.JUnit4$2;
import com.carrotsearch.ant.tasks.junit4.JUnit4$3;
import com.carrotsearch.ant.tasks.junit4.JUnit4$ExtendedPropertySet;
import com.carrotsearch.ant.tasks.junit4.JUnit4$ExtendedVariable;
import com.carrotsearch.ant.tasks.junit4.JUnit4$JvmOutputAction;
import com.carrotsearch.ant.tasks.junit4.ListenersList;
import com.carrotsearch.ant.tasks.junit4.LocalSlaveStreamHandler;
import com.carrotsearch.ant.tasks.junit4.SlaveInfo;
import com.carrotsearch.ant.tasks.junit4.SuiteBalancer$Assignment;
import com.carrotsearch.ant.tasks.junit4.TailInputStream;
import com.carrotsearch.ant.tasks.junit4.TestsSummary;
import com.carrotsearch.ant.tasks.junit4.TestsSummaryEventListener;
import com.carrotsearch.ant.tasks.junit4.balancers.RoundRobinBalancer;
import com.carrotsearch.ant.tasks.junit4.balancers.SuiteHint;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.ClassGlobFilter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.MethodGlobFilter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Joiner;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Objects;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Throwables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.HashMultiset;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.eventbus.EventBus;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.CharStreams;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closeables;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Files;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.Gson;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.apache.commons.io.FileUtils;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.apache.commons.io.output.TeeOutputStream;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.objectweb.asm.ClassReader;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedQuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedStartEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatingListener;
import com.carrotsearch.ant.tasks.junit4.listeners.AggregatedEventListener;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMain;
import com.carrotsearch.ant.tasks.junit4.slave.SlaveMainSafe;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Assertions;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.util.LoaderUtils;
import org.junit.runner.Description;

public class JUnit4
extends Task {
    private static String[] WELCOME_MESSAGES = new String[]{"hello!", "hi!", "g'day!", "\u00a1Hola!", "jolly good day!", "aloha!", "cze\u015b\u0107!", "\u0645\u0631\u062d\u0628\u0627!", "kaixo!", "\u041f\u0440\u0438\u0432\u0435\u0442!", "\u4f60\u597d!", "ahoj!", "salut!", "hallo!", "\u05e9\u05dc\u05d5\u05dd!", "\u0928\u092e\u0938\u094d\u0924\u0947!", "\u140a\u1403!", "ciao!", "\u4eca\u65e5\u306f!", "ol\u00e1!"};
    public static final String ANTLIB_RESOURCE_NAME = "com/carrotsearch/junit4/antlib.xml";
    public static final Object PARALLELISM_AUTO = "auto";
    public static final String PARALLELISM_MAX = "max";
    public static final boolean DEFAULT_SHUFFLE_ON_SLAVE = true;
    public static final String DEFAULT_PARALLELISM = "1";
    public static final boolean DEFAULT_PRINT_SUMMARY = true;
    public static final boolean DEFAULT_HALT_ON_FAILURE = true;
    public static final boolean DEFAULT_ISOLATE_WORKING_DIRECTORIES = true;
    public static final float DEFAULT_DYNAMIC_ASSIGNMENT_RATIO = 0.25f;
    public static final boolean DEFAULT_SYSOUTS = false;
    private static final String CHILDVM_SYSPROP_CWD = "junit4.childvm.cwd";
    private static final String CHILDVM_SYSPROP_ID = "junit4.childvm.id";
    public EnumSet jvmOutputAction = EnumSet.of(JUnit4$JvmOutputAction.PIPE, JUnit4$JvmOutputAction.WARN);
    private boolean sysouts = false;
    private CommandlineJava slaveCommand = new CommandlineJava();
    private boolean newEnvironment;
    private boolean uniqueSuiteNames = true;
    private Environment env = new Environment();
    private File dir;
    private final Resources resources;
    private boolean haltOnFailure = true;
    private boolean printSummary = true;
    private String failureProperty;
    private File tempDir;
    private List listeners = Lists.newArrayList();
    private List balancers = Lists.newArrayList();
    private AntClassLoader testsClassLoader;
    private String parallelism = "1";
    private boolean leaveTemporary;
    private List temporaryFiles = Collections.synchronizedList(Lists.newArrayList());
    private String random;
    private boolean isolateWorkingDirectories = true;
    private Path classpath;
    private Path bootclasspath;
    private float dynamicAssignmentRatio = 0.25f;
    private boolean shuffleOnSlave = true;
    private long heartbeat;

    public JUnit4() {
        this.resources = new Resources();
    }

    public void setJvmOutputAction(String string) {
        EnumSet<JUnit4$JvmOutputAction> enumSet = EnumSet.noneOf(JUnit4$JvmOutputAction.class);
        for (String string2 : string.split("[\\,\\ ]+")) {
            string2 = string2.trim().toUpperCase(Locale.ENGLISH);
            enumSet.add(JUnit4$JvmOutputAction.valueOf(string2));
        }
        this.jvmOutputAction = enumSet;
    }

    public void setSysouts(boolean bl) {
        this.sysouts = bl;
    }

    public void setUniqueSuiteNames(boolean bl) {
        this.uniqueSuiteNames = bl;
    }

    public void setDynamicAssignmentRatio(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Dynamic assignment ratio must be between 0 (only static assignments) to 1 (fully dynamic assignments).");
        }
        this.dynamicAssignmentRatio = f;
    }

    public void setParallelism(String string) {
        this.parallelism = string;
    }

    public void setFailureProperty(String string) {
        this.failureProperty = string;
    }

    public void setNewEnvironment(boolean bl) {
        this.newEnvironment = bl;
    }

    public void setSeed(String string) {
        if (!Strings.isNullOrEmpty(this.getProject().getUserProperty(SysGlobals.SYSPROP_RANDOM_SEED()))) {
            String string2 = this.getProject().getUserProperty(SysGlobals.SYSPROP_RANDOM_SEED());
            if (!string2.equals(string)) {
                this.log("Ignoring seed attribute because it is overridden by user properties.", 1);
            }
        } else if (!Strings.isNullOrEmpty(string)) {
            this.random = string;
        }
    }

    public void setPrefix(String string) {
        if (!Strings.isNullOrEmpty(this.getProject().getUserProperty(SysGlobals.SYSPROP_PREFIX()))) {
            this.log("Ignoring prefix attribute because it is overridden by user properties.", 1);
        } else {
            SysGlobals.initializeWith(string);
        }
    }

    public String getSeed() {
        return this.random;
    }

    public void setShuffleOnSlave(boolean bl) {
        this.shuffleOnSlave = bl;
    }

    public void setProject(Project project) {
        super.setProject(project);
        this.resources.setProject(project);
        this.classpath = new Path(this.getProject());
        this.bootclasspath = new Path(this.getProject());
    }

    public void setPrintSummary(boolean bl) {
        this.printSummary = bl;
    }

    public void setHaltOnFailure(boolean bl) {
        this.haltOnFailure = bl;
    }

    public void setMaxmemory(String string) {
        if (!Strings.isNullOrEmpty(string)) {
            this.getCommandline().setMaxmemory(string);
        }
    }

    public void setLeaveTemporary(boolean bl) {
        this.leaveTemporary = bl;
    }

    public Commandline.Argument createJvmarg() {
        return this.getCommandline().createVmArgument();
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setTempDir(File file) {
        this.tempDir = file;
    }

    public void addConfiguredSysproperty(JUnit4$ExtendedVariable jUnit4$ExtendedVariable) {
        if (!jUnit4$ExtendedVariable.shouldIgnore()) {
            this.getCommandline().addSysproperty((Environment.Variable)jUnit4$ExtendedVariable);
        }
    }

    public void addConfiguredSyspropertyset(JUnit4$ExtendedPropertySet jUnit4$ExtendedPropertySet) {
        this.getCommandline().addSyspropertyset((PropertySet)jUnit4$ExtendedPropertySet);
    }

    public void setJvm(String string) {
        if (!Strings.isNullOrEmpty(string)) {
            this.getCommandline().setVm(string);
        }
    }

    public void setIsolateWorkingDirectories(boolean bl) {
        this.isolateWorkingDirectories = bl;
    }

    public void addEnv(JUnit4$ExtendedVariable jUnit4$ExtendedVariable) {
        this.env.addVariable((Environment.Variable)jUnit4$ExtendedVariable);
    }

    public void addFileSet(FileSet fileSet) {
        this.add((ResourceCollection)fileSet);
        if (fileSet.getProject() == null) {
            fileSet.setProject(this.getProject());
        }
    }

    public void add(ResourceCollection resourceCollection) {
        this.resources.add(resourceCollection);
    }

    public ListenersList createListeners() {
        return new ListenersList(this.listeners);
    }

    public void addAssertions(Assertions assertions) {
        if (this.getCommandline().getAssertions() != null) {
            throw new BuildException("Only one assertion declaration is allowed");
        }
        this.getCommandline().setAssertions(assertions);
    }

    public BalancersList createBalancers() {
        return new BalancersList(this.balancers);
    }

    public Path createClasspath() {
        return this.classpath.createPath();
    }

    public Path createBootclasspath() {
        return this.bootclasspath.createPath();
    }

    public void setFork(boolean bl) {
        this.warnUnsupported("fork");
    }

    public void setForkmode(String string) {
        this.warnUnsupported("forkmode");
    }

    public void setHaltOnError(boolean bl) {
        this.warnUnsupported("haltonerror");
    }

    public void setFiltertrace(boolean bl) {
        this.warnUnsupported("filtertrace");
        this.log("Hint: report listeners have stack filtering options.", 1);
    }

    public void setTimeout(String string) {
        this.warnUnsupported("timeout");
    }

    public void setIncludeantruntime(String string) {
        this.warnUnsupported("includeantruntime");
    }

    public void setShowoutput(String string) {
        this.warnUnsupported("showoutput");
    }

    public void setOutputtoformatters(String string) {
        this.warnUnsupported("outputtoformatters");
    }

    public void setReloading(String string) {
        this.warnUnsupported("reloading");
    }

    public void setClonevm(String string) {
        this.warnUnsupported("clonevm");
    }

    public void setErrorproperty(String string) {
        this.warnUnsupported("errorproperty");
    }

    public void setLogfailedtests(String string) {
        this.warnUnsupported("logfailedtests");
    }

    public void setEnableTestListenerEvents(String string) {
        this.warnUnsupported("enableTestListenerEvents");
    }

    public Object createFormatter() {
        throw new BuildException("<formatter> elements are not supported by <junit4>. Refer to the documentation about listeners and reports.");
    }

    public Object createTest() {
        throw new BuildException("<test> elements are not supported by <junit4>. Use regular ANT resource collections to point at individual tests or their groups.");
    }

    public Object createBatchtest() {
        throw new BuildException("<batchtest> elements are not supported by <junit4>. Use regular ANT resource collections to point at individual tests or their groups.");
    }

    private void warnUnsupported(String string) {
        this.log("The '" + string + "' attribute is not supported by <junit4>.", 1);
    }

    public void setHeartbeat(long l) {
        this.heartbeat = l;
    }

    public void execute() {
        Object object;
        this.validateJUnit4();
        this.validateArguments();
        if (this.random == null) {
            this.random = (String)Objects.firstNonNull(Strings.emptyToNull(this.getProject().getProperty(SysGlobals.SYSPROP_RANDOM_SEED())), SeedUtils.formatSeed(new Random().nextLong()));
        }
        this.masterSeed();
        this.log("<JUnit4> says " + (String)RandomPicks.randomFrom(new Random(this.masterSeed()), WELCOME_MESSAGES) + " Master seed: " + this.getSeed(), 2);
        this.createJvmarg().setValue("-D" + SysGlobals.SYSPROP_PREFIX() + "=" + SysGlobals.CURRENT_PREFIX());
        this.createJvmarg().setValue("-D" + SysGlobals.SYSPROP_RANDOM_SEED() + "=" + this.random);
        this.classpath = this.resolveFiles(this.classpath);
        this.bootclasspath = this.resolveFiles(this.bootclasspath);
        this.getCommandline().createClasspath(this.getProject()).add(this.classpath);
        this.getCommandline().createBootclasspath(this.getProject()).add(this.bootclasspath);
        this.testsClassLoader = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.getCommandline().getClasspath(), true);
        String string = Strings.emptyToNull(this.getProject().getProperty(SysGlobals.SYSPROP_TESTMETHOD()));
        if (string != null) {
            Environment.Variable variable = new Environment.Variable();
            variable.setKey(SysGlobals.SYSPROP_TESTMETHOD());
            variable.setValue(string);
            this.getCommandline().addSysproperty(variable);
        }
        long l = System.currentTimeMillis();
        List list = this.processTestResources();
        EventBus eventBus = new EventBus("aggregated");
        TestsSummaryEventListener testsSummaryEventListener = new TestsSummaryEventListener();
        eventBus.register(testsSummaryEventListener);
        for (Object object2 : this.listeners) {
            if (object2 instanceof ProjectComponent) {
                ((ProjectComponent)object2).setProject(this.getProject());
            }
            if (object2 instanceof AggregatedEventListener) {
                ((AggregatedEventListener)object2).setOuter(this);
            }
            eventBus.register(object2);
        }
        if (list.isEmpty()) {
            eventBus.post(new AggregatedQuitEvent());
        } else {
            Object object3;
            Object object4;
            Object object2;
            l = System.currentTimeMillis();
            if (this.uniqueSuiteNames) {
                object = Lists.newArrayList(new HashSet(list));
                list.clear();
                list.addAll(object);
            }
            int n = this.determineSlaveCount(list.size());
            object2 = Lists.newArrayList();
            for (int i = 0; i < n; ++i) {
                object4 = new SlaveInfo(i, n);
                object2.add(object4);
            }
            Collections.sort(list);
            Serializable serializable = new ArrayDeque(this.loadBalanceSuites((List)object2, list, this.balancers));
            eventBus.register(new JUnit4$1(this, (Deque)((Object)serializable)));
            object4 = Lists.newArrayList();
            for (int i = 0; i < n; ++i) {
                object3 = (SlaveInfo)object2.get(i);
                object4.add(new JUnit4$2(this, (SlaveInfo)object3, eventBus));
            }
            ExecutorService executorService = Executors.newCachedThreadPool();
            eventBus.post(new AggregatedStartEvent(object4.size(), list.size()));
            try {
                object3 = executorService.invokeAll(object4);
                executorService.shutdown();
                for (int i = 0; i < object4.size(); ++i) {
                    Object object5 = (Future)object3.get(i);
                    try {
                        object5.get();
                        continue;
                    }
                    catch (ExecutionException executionException) {
                        ((SlaveInfo)object2.get((int)i)).executionError = executionException.getCause();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                this.log("Master interrupted? Weird.", 0);
            }
            eventBus.post(new AggregatedQuitEvent());
            for (SlaveInfo slaveInfo : object2) {
                if (slaveInfo.start <= 0L || slaveInfo.end <= 0L) continue;
                this.log(String.format(Locale.ENGLISH, "JVM J%d: %8.2f .. %8.2f = %8.2fs", slaveInfo.id, Float.valueOf((float)(slaveInfo.start - l) / 1000.0f), Float.valueOf((float)(slaveInfo.end - l) / 1000.0f), Float.valueOf((float)slaveInfo.getExecutionTime() / 1000.0f)), 2);
            }
            this.log("Execution time total: " + Duration.toHumanDuration(System.currentTimeMillis() - l));
            object3 = null;
            for (Object object5 : object2) {
                if (((SlaveInfo)object5).executionError == null) continue;
                this.log("ERROR: JVM J" + ((SlaveInfo)object5).id + " ended with an exception, command line: " + ((SlaveInfo)object5).getCommandLine());
                this.log("ERROR: JVM J" + ((SlaveInfo)object5).id + " ended with an exception: " + Throwables.getStackTraceAsString(((SlaveInfo)object5).executionError), 0);
                if (object3 != null) continue;
                object3 = object5;
            }
            if (object3 != null) {
                throw new BuildException("At least one slave process threw an exception, first: " + ((SlaveInfo)object3).executionError.getMessage(), ((SlaveInfo)object3).executionError);
            }
        }
        object = testsSummaryEventListener.getResult();
        if (this.printSummary) {
            this.log("Tests summary: " + object, 2);
        }
        if (!((TestsSummary)object).isSuccessful()) {
            if (!Strings.isNullOrEmpty(this.failureProperty)) {
                this.getProject().setNewProperty(this.failureProperty, "true");
            }
            if (this.haltOnFailure) {
                throw new BuildException("There were test failures: " + object);
            }
        }
        if (!this.leaveTemporary) {
            for (Serializable serializable : this.temporaryFiles) {
                try {
                    if (serializable == null || FileUtils.deleteQuietly((File)serializable)) continue;
                    throw new IOException();
                }
                catch (IOException iOException) {
                    this.log("Could not remove temporary path: " + ((File)serializable).getAbsolutePath(), 1);
                }
            }
        }
    }

    private void validateArguments() {
        File file = this.getTempDir();
        if (file == null) {
            throw new BuildException("Temporary directory cannot be null.");
        }
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new BuildException("Temporary directory is not a folder: " + file.getAbsolutePath());
            }
        } else if (!file.mkdirs()) {
            throw new BuildException("Failed to create temporary directory: " + file.getAbsolutePath());
        }
    }

    private void validateJUnit4() {
        try {
            Class<?> clazz = Class.forName("org.junit.runner.Description");
            if (!Serializable.class.isAssignableFrom(clazz)) {
                throw new BuildException("At least JUnit version 4.10 is required on junit4's taskdef classpath.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BuildException("JUnit JAR must be added to junit4 taskdef's classpath.");
        }
    }

    private List loadBalanceSuites(List list, List list2, List list3) {
        Object object;
        Iterator iterator32;
        Object object222;
        Iterator iterator222;
        ArrayList arrayList = Lists.newArrayList(list3);
        arrayList.add(new RoundRobinBalancer());
        HashMultiset hashMultiset = HashMultiset.create(list2);
        HashMap hashMap = Maps.newHashMap();
        for (Iterator iterator222 : list) {
            hashMap.put(((SlaveInfo)((Object)iterator222)).id, Lists.newArrayList());
        }
        int n = list.size();
        for (Object object222 : arrayList) {
            object222.setOwner(this);
            iterator32 = object222.assign(Collections.unmodifiableCollection(hashMultiset), n, this.masterSeed());
            object = iterator32.iterator();
            while (object.hasNext()) {
                SuiteBalancer$Assignment suiteBalancer$Assignment = (SuiteBalancer$Assignment)object.next();
                if (suiteBalancer$Assignment == null) {
                    throw new RuntimeException("Balancer must return non-null assignments.");
                }
                if (!hashMultiset.remove(suiteBalancer$Assignment.suiteName)) {
                    throw new RuntimeException("Balancer must return suite name as a key: " + suiteBalancer$Assignment.suiteName);
                }
                this.log(String.format(Locale.ENGLISH, "Assignment hint: J%-2d (cost %5d) %s (by %s)", suiteBalancer$Assignment.slaveId, suiteBalancer$Assignment.estimatedCost, suiteBalancer$Assignment.suiteName, object222.getClass().getSimpleName()), 3);
                ((List)hashMap.get(suiteBalancer$Assignment.slaveId)).add(suiteBalancer$Assignment);
            }
        }
        if (hashMultiset.size() != 0) {
            throw new RuntimeException("Not all suites assigned?: " + hashMultiset);
        }
        if (this.shuffleOnSlave) {
            for (Object object222 : hashMap.values()) {
                Collections.sort(object222);
                Collections.shuffle(object222, new Random(this.masterSeed()));
            }
        }
        iterator222 = Lists.newArrayList();
        for (Iterator iterator32 : list) {
            List<String> list4;
            object = (List)hashMap.get(((SlaveInfo)((Object)iterator32)).id);
            int n2 = (int)((float)object.size() * this.dynamicAssignmentRatio);
            if (n2 > 0) {
                list4 = object.subList(object.size() - n2, object.size());
                for (SuiteBalancer$Assignment suiteBalancer$Assignment : list4) {
                    iterator222.add((SuiteHint)new SuiteHint(suiteBalancer$Assignment.suiteName, suiteBalancer$Assignment.estimatedCost));
                }
                list4.clear();
            }
            ((SlaveInfo)((Object)iterator32)).testSuites = Lists.newArrayList();
            list4 = ((SlaveInfo)((Object)iterator32)).testSuites;
            Iterator iterator4 = object.iterator();
            while (iterator4.hasNext()) {
                SuiteBalancer$Assignment suiteBalancer$Assignment = (SuiteBalancer$Assignment)iterator4.next();
                ((ArrayList)list4).add(suiteBalancer$Assignment.suiteName);
            }
        }
        Collections.sort(iterator222, SuiteHint.DESCENDING_BY_WEIGHT);
        for (Iterator iterator32 : list) {
            this.log("Forked JVM J" + ((SlaveInfo)((Object)iterator32)).id + " assignments (after shuffle):", 3);
            for (String string : ((SlaveInfo)((Object)iterator32)).testSuites) {
                this.log("  " + string, 3);
            }
        }
        this.log("Stealing queue:", 3);
        object222 = iterator222.iterator();
        while (object222.hasNext()) {
            iterator32 = (SuiteHint)object222.next();
            this.log("  " + ((SuiteHint)((Object)iterator32)).suiteName + " " + ((SuiteHint)((Object)iterator32)).cost, 3);
        }
        object222 = Lists.newArrayListWithCapacity(iterator222.size());
        iterator32 = iterator222.iterator();
        while (iterator32.hasNext()) {
            object = (SuiteHint)iterator32.next();
            object222.add(((SuiteHint)object).suiteName);
        }
        return object222;
    }

    private long masterSeed() {
        long[] lArray = SeedUtils.parseSeedChain(this.getSeed());
        if (lArray.length < 1) {
            throw new BuildException("Random seed is required.");
        }
        return lArray[0];
    }

    private Path resolveFiles(Path path) {
        Path path2 = new Path(this.getProject());
        for (String string : path.list()) {
            path2.createPathElement().setLocation(new File(string));
        }
        return path2;
    }

    private int determineSlaveCount(int n) {
        int n2;
        int n3 = Runtime.getRuntime().availableProcessors();
        if (this.parallelism.equals(PARALLELISM_AUTO)) {
            n2 = n3 >= 8 ? 4 : (n3 >= 4 ? 3 : 1);
        } else if (this.parallelism.equals(PARALLELISM_MAX)) {
            n2 = Runtime.getRuntime().availableProcessors();
        } else {
            try {
                n2 = Math.max(1, Integer.parseInt(this.parallelism));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BuildException("parallelism must be 'auto', 'max' or a valid integer: " + this.parallelism);
            }
        }
        n2 = Math.min(n, n2);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSlave(SlaveInfo slaveInfo, EventBus eventBus) {
        String string = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS").format(new Date());
        File file = this.tempFile(string, "junit4-J" + slaveInfo.id, ".suites", this.getTempDir());
        this.temporaryFiles.add(file);
        File file2 = this.tempFile(string, "junit4-J" + slaveInfo.id, ".dynamic-suites", this.getTempDir());
        File file3 = this.tempFile(string, "junit4-J" + slaveInfo.id, ".spill", this.getTempDir());
        String string2 = Joiner.on("\n").join(slaveInfo.testSuites);
        this.log("Test class names:\n" + string2, 3);
        Files.write(string2, file, Charsets.UTF_8);
        CommandlineJava commandlineJava = (CommandlineJava)this.getCommandline().clone();
        commandlineJava.createClasspath(this.getProject()).add(this.addSlaveClasspath());
        commandlineJava.setClassname(SlaveMainSafe.class.getName());
        if (slaveInfo.slaves == 1) {
            commandlineJava.createArgument().setValue("-flush");
        }
        File file4 = this.tempFile(string, "junit4-J" + slaveInfo.id, ".sysout", this.getTempDir());
        File file5 = this.tempFile(string, "junit4-J" + slaveInfo.id, ".syserr", this.getTempDir());
        File file6 = this.tempFile(string, "junit4-J" + slaveInfo.id, ".events", this.getTempDir());
        this.temporaryFiles.add(file6);
        commandlineJava.createArgument().setValue("-eventsfile");
        commandlineJava.createArgument().setFile(file6);
        if (this.sysouts) {
            commandlineJava.createArgument().setValue("-sysouts");
        }
        TailInputStream tailInputStream = new TailInputStream(file6);
        commandlineJava.createArgument().setValue("@" + file.getAbsolutePath());
        slaveInfo.slaveCommandLine = this.escapeAndJoin(commandlineJava.getCommandline());
        this.log("Forked JVM process command line (may need escape sequences for your shell):\n" + slaveInfo.slaveCommandLine, 3);
        commandlineJava.createArgument().setValue("-stdin");
        EventBus eventBus2 = new EventBus("slave-" + slaveInfo.id);
        DiagnosticsListener diagnosticsListener = new DiagnosticsListener(slaveInfo, this);
        eventBus2.register(diagnosticsListener);
        eventBus2.register(new AggregatingListener(eventBus, slaveInfo));
        AtomicReference atomicReference = new AtomicReference();
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        PrintWriter printWriter = new PrintWriter(Files.newWriter(file2, Charsets.UTF_8));
        eventBus2.register(new JUnit4$3(this, eventBus, atomicReference, atomicBoolean, slaveInfo, printWriter));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file4));
        BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(new FileOutputStream(file5));
        Exception exception = null;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file3, "rw");
        try {
            Execute execute = this.forkProcess(slaveInfo, eventBus2, commandlineJava, tailInputStream, bufferedOutputStream, bufferedOutputStream2, randomAccessFile);
            this.log("Forked JVM J" + slaveInfo.id + " finished with exit code: " + execute.getExitValue(), 4);
            if (execute.isFailure()) {
                int n = execute.getExitValue();
                switch (n) {
                    case 239: {
                        throw new BuildException("Forked JVM's classpath must include a junit4 JAR.");
                    }
                    case 238: {
                        throw new BuildException("Forked JVM's classpath must use JUnit 4.10 or newer.");
                    }
                }
                Closeables.closeQuietly(bufferedOutputStream);
                Closeables.closeQuietly(bufferedOutputStream2);
                StringBuilder stringBuilder = new StringBuilder();
                if (n == 237) {
                    stringBuilder.append("Forked JVM ran out of memory.");
                } else {
                    stringBuilder.append("Forked process returned with error code: ").append(n).append(".");
                }
                if (file4.length() > 0L || file5.length() > 0L) {
                    if (n != 237) {
                        stringBuilder.append(" Very likely a JVM crash. ");
                    }
                    if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.PIPE)) {
                        stringBuilder.append(" Process output piped in logs above.");
                    } else if (!this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.IGNORE)) {
                        if (file4.length() > 0L) {
                            stringBuilder.append(" See process stdout at: " + file4.getAbsolutePath());
                        }
                        if (file5.length() > 0L) {
                            stringBuilder.append(" See process stderr at: " + file5.getAbsolutePath());
                        }
                    }
                }
                throw new BuildException(stringBuilder.toString());
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        finally {
            Closeables.closeQuietly(tailInputStream);
            Closeables.closeQuietly(printWriter);
            Closeables.closeQuietly(bufferedOutputStream);
            Closeables.closeQuietly(bufferedOutputStream2);
            Closeables.closeQuietly(randomAccessFile);
            Files.copy(file2, Files.newOutputStreamSupplier(file, true));
            file2.delete();
            file3.delete();
        }
        this.checkJvmOutput(file4, slaveInfo, "stdout");
        this.checkJvmOutput(file5, slaveInfo, "stderr");
        if (exception != null) {
            throw exception;
        }
        if (!diagnosticsListener.quitReceived()) {
            throw new BuildException("Quit event not received from a slave process? This may indicate JVM crash or runner bugs.");
        }
        if (atomicBoolean.get() && this.dynamicAssignmentRatio > 0.0f) {
            throw new BuildException("Forked JVM J" + slaveInfo.id + " was not be able to decode class names when using" + " charset: " + atomicReference + ". Do not use " + "dynamic suite balancing to work around this problem (-DdynamicAssignmentRatio=0).");
        }
    }

    private void checkJvmOutput(File file, SlaveInfo slaveInfo, String string) {
        if (file.length() > 0L) {
            String string2 = "JVM J" + slaveInfo.id + ": " + string + " was not empty, see: " + file;
            if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.WARN)) {
                this.log(string2, 1);
            }
            if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.PIPE)) {
                this.log(">>> JVM J" + slaveInfo.id + ": " + string + " (verbatim) ----", 2);
                try {
                    if (file.length() < 0xA00000L) {
                        this.log(Files.toString(file, slaveInfo.getCharset()), 2);
                    } else {
                        CharStreams.copy(Files.newReader(file, slaveInfo.getCharset()), System.out);
                    }
                }
                catch (IOException iOException) {
                    this.log("Couldn't pipe file " + file + ": " + iOException.toString(), 2);
                }
                this.log("<<< JVM J" + slaveInfo.id + ": EOF ----", 2);
            }
            if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.IGNORE)) {
                file.delete();
            }
            if (this.jvmOutputAction.contains((Object)JUnit4$JvmOutputAction.FAIL)) {
                throw new BuildException(string2);
            }
            return;
        }
        file.delete();
    }

    private File tempFile(String string, String string2, String string3, File file) {
        File file2;
        int n = 0;
        while (!(file2 = n > 0 ? new File(file, string2 + "-" + string + "_retry" + n + string3) : new File(file, string2 + "-" + string + string3)).createNewFile() && n++ < 5) {
        }
        return file2;
    }

    private String escapeAndJoin(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Pattern pattern = Pattern.compile("[\\ ]");
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            if (pattern.matcher(string).find()) {
                stringBuilder.append('\"').append(string).append('\"');
                continue;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private Execute forkProcess(SlaveInfo slaveInfo, EventBus eventBus, CommandlineJava commandlineJava, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, RandomAccessFile randomAccessFile) {
        try {
            LocalSlaveStreamHandler localSlaveStreamHandler = new LocalSlaveStreamHandler(eventBus, (ClassLoader)this.testsClassLoader, System.err, inputStream, outputStream, outputStream2, this.heartbeat, randomAccessFile);
            File file = this.getWorkingDirectory(slaveInfo);
            Environment.Variable variable = new Environment.Variable();
            variable.setKey(CHILDVM_SYSPROP_CWD);
            variable.setFile(file.getAbsoluteFile());
            commandlineJava.addSysproperty(variable);
            variable = new Environment.Variable();
            variable.setKey(CHILDVM_SYSPROP_ID);
            variable.setValue(Integer.toString(slaveInfo.id));
            commandlineJava.addSysproperty(variable);
            Execute execute = new Execute();
            execute.setCommandline(commandlineJava.getCommandline());
            execute.setVMLauncher(true);
            execute.setWorkingDirectory(file);
            execute.setStreamHandler((ExecuteStreamHandler)localSlaveStreamHandler);
            execute.setNewenvironment(this.newEnvironment);
            if (this.env.getVariables() != null) {
                execute.setEnvironment(this.env.getVariables());
            }
            this.log("Starting JVM J" + slaveInfo.id, 4);
            execute.execute();
            return execute;
        }
        catch (IOException iOException) {
            throw new BuildException("Could not execute slave process. Run ant with -verbose to get the execution details.", (Throwable)iOException);
        }
    }

    private File getWorkingDirectory(SlaveInfo slaveInfo) {
        File file;
        File file2;
        File file3 = file2 = this.dir == null ? this.getProject().getBaseDir() : this.dir;
        if (this.isolateWorkingDirectories) {
            file = new File(file2, "J" + slaveInfo.id);
            file.mkdirs();
            this.temporaryFiles.add(file);
        } else {
            file = file2;
        }
        return file;
    }

    private File getTempDir() {
        if (this.tempDir == null) {
            this.tempDir = this.dir != null ? this.dir : this.getProject().getBaseDir();
        }
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List processTestResources() {
        Object object;
        Object object2;
        Object object3;
        ArrayList arrayList = Lists.newArrayList();
        this.resources.setProject(this.getProject());
        Iterator iterator = this.resources.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            object3 = (Resource)iterator.next();
            if (!object3.isExists()) {
                throw new BuildException("Test class resource does not exist?: " + object3.getName());
            }
            try {
                if (object3.getName().endsWith(".java")) {
                    object2 = object3.getName();
                    object = ((String)object2).substring(0, ((String)object2).length() - ".java".length());
                    object = ((String)object).replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.');
                    arrayList.add(object);
                    if (bl) continue;
                    this.log("Source (.java) files used for naming source suites. This is discouraged, use a resource collection pointing to .class files instead.", 2);
                    bl = true;
                    continue;
                }
                object2 = object3.getInputStream();
                if (!((InputStream)object2).markSupported()) {
                    object2 = new BufferedInputStream((InputStream)object2);
                }
                try {
                    ((InputStream)object2).mark(4);
                    if (((InputStream)object2).read() != 202 || ((InputStream)object2).read() != 254 || ((InputStream)object2).read() != 186 || ((InputStream)object2).read() != 190) {
                        throw new BuildException("File does not start with a class magic 0xcafebabe: " + object3.getName() + ", " + object3.getLocation());
                    }
                    ((InputStream)object2).reset();
                    object = new ClassReader((InputStream)object2);
                    String string = ((ClassReader)object).getClassName().replace('/', '.');
                    this.log("Test class parsed: " + object3.getName() + " as " + ((ClassReader)object).getClassName(), 4);
                    arrayList.add(string);
                }
                finally {
                    ((InputStream)object2).close();
                }
            }
            catch (IOException iOException) {
                throw new BuildException("Could not read or parse as Java class: " + object3.getName() + ", " + object3.getLocation());
            }
        }
        object3 = Strings.emptyToNull(this.getProject().getProperty(SysGlobals.SYSPROP_TESTCLASS()));
        if (object3 != null) {
            object2 = new ClassGlobFilter((String)object3);
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (((ClassGlobFilter)((Object)object2)).shouldRun(Description.createSuiteDescription((String)((String)object.next()), (Annotation[])new Annotation[0]))) continue;
                object.remove();
            }
        }
        return arrayList;
    }

    private CommandlineJava getCommandline() {
        return this.slaveCommand;
    }

    private Path addSlaveClasspath() {
        Path path = new Path(this.getProject());
        String[] stringArray = new String[]{SlaveMain.class.getName(), Strings.class.getName(), MethodGlobFilter.class.getName(), Gson.class.getName(), TeeOutputStream.class.getName()};
        for (String string : Arrays.asList(stringArray)) {
            String string2 = string.replace(".", "/") + ".class";
            File file = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)string2);
            if (file != null) {
                path.createPath().setLocation(file);
                continue;
            }
            throw new BuildException("Could not locate classpath for resource: " + string2);
        }
        return path;
    }

    static /* synthetic */ void access$000(JUnit4 jUnit4, SlaveInfo slaveInfo, EventBus eventBus) {
        jUnit4.executeSlave(slaveInfo, eventBus);
    }
}

