/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.client.http;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.seasar.extension.timer.TimeoutTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HcConnectionMonitorTarget
implements TimeoutTarget {
    private static final Logger logger = LoggerFactory.getLogger(HcConnectionMonitorTarget.class);
    private ClientConnectionManager clientConnectionManager;
    private long idleConnectionTimeout;

    public HcConnectionMonitorTarget(ClientConnectionManager clientConnectionManager, long idleConnectionTimeout) {
        this.clientConnectionManager = clientConnectionManager;
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public void expired() {
        try {
            this.clientConnectionManager.closeExpiredConnections();
            this.clientConnectionManager.closeIdleConnections(this.idleConnectionTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("A connection monitoring exception occurs.", (Throwable)e);
        }
    }
}

