/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.client.http;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.seasar.framework.util.StringUtil;
import org.seasar.robot.RobotSystemException;

public class BasicAuthentication {
    private String host;
    private Integer port;
    private String realm;
    private String scheme;
    private String username;
    private String password;

    public BasicAuthentication(String host, Integer port, String realm, String scheme, String username, String password) {
        this.host = host;
        this.port = port;
        this.realm = realm;
        this.scheme = scheme;
        this.username = username;
        this.password = password;
    }

    public AuthScope getAuthScope() {
        String s;
        if (StringUtil.isBlank((String)this.host)) {
            return AuthScope.ANY;
        }
        int p = this.port == null ? -1 : this.port;
        String r = this.realm;
        if (StringUtil.isBlank((String)r)) {
            r = AuthScope.ANY_REALM;
        }
        if (StringUtil.isBlank((String)(s = this.scheme))) {
            s = AuthScope.ANY_SCHEME;
        }
        return new AuthScope(this.host, p, r, s);
    }

    public Credentials getCredentials() {
        if (StringUtil.isEmpty((String)this.username)) {
            throw new RobotSystemException("username is empty.");
        }
        return new UsernamePasswordCredentials(this.username, this.password == null ? "" : this.password);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

