/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.robot.db.allcommon;

import org.seasar.robot.db.allcommon.DBCurrent;
import org.seasar.robot.db.allcommon.DBFluteConfig;
import org.seasar.robot.db.allcommon.DBMetaInstanceHandler;
import org.seasar.robot.dbflute.DBDef;
import org.seasar.robot.dbflute.cbean.ConditionBean;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClause;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseCreator;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseDb2;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseDefault;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseDerby;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseFirebird;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseH2;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseMsAccess;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseMySql;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseOracle;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClausePostgreSql;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseSqlServer;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseSqlite;
import org.seasar.robot.dbflute.cbean.sqlclause.SqlClauseSybase;
import org.seasar.robot.dbflute.dbmeta.DBMetaProvider;

public class ImplementedSqlClauseCreator
implements SqlClauseCreator {
    public SqlClause createSqlClause(ConditionBean cb) {
        String tableDbName = cb.getTableDbName();
        SqlClause sqlClause = this.createSqlClause(tableDbName);
        return sqlClause;
    }

    public SqlClause createSqlClause(String tableDbName) {
        DBMetaProvider dbmetaProvider = DBMetaInstanceHandler.getProvider();
        SqlClause sqlClause = this.doCreateSqlClause(tableDbName, dbmetaProvider);
        this.setupSqlClauseOption(sqlClause);
        return sqlClause;
    }

    protected SqlClause doCreateSqlClause(String tableDbName, DBMetaProvider dbmetaProvider) {
        SqlClause sqlClause = this.isCurrentDBDef(DBDef.MySQL) ? this.createSqlClauseMySql(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.PostgreSQL) ? this.createSqlClausePostgreSql(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.Oracle) ? this.createSqlClauseOracle(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.DB2) ? this.createSqlClauseDb2(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.SQLServer) ? this.createSqlClauseSqlServer(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.H2) ? this.createSqlClauseH2(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.Derby) ? this.createSqlClauseDerby(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.SQLite) ? this.createSqlClauseSqlite(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.MSAccess) ? this.createSqlClauseMsAccess(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.FireBird) ? this.createSqlClauseFirebird(tableDbName, dbmetaProvider) : (this.isCurrentDBDef(DBDef.Sybase) ? this.createSqlClauseSybase(tableDbName, dbmetaProvider) : this.createSqlClauseH2(tableDbName, dbmetaProvider)))))))))));
        return sqlClause;
    }

    protected SqlClause createSqlClauseMySql(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseMySql(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClausePostgreSql(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClausePostgreSql(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseOracle(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseOracle(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseDb2(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseDb2(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseSqlServer(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseSqlServer(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseH2(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseH2(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseDerby(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseDerby(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseSqlite(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseSqlite(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseMsAccess(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseMsAccess(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseFirebird(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseFirebird(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseSybase(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseSybase(tableDbName).provider(dbmetaProvider);
    }

    protected SqlClause createSqlClauseDefault(String tableDbName, DBMetaProvider dbmetaProvider) {
        return new SqlClauseDefault(tableDbName).provider(dbmetaProvider);
    }

    protected void setupSqlClauseOption(SqlClause sqlClause) {
        if (this.isDisableSelectIndex()) {
            sqlClause.disableSelectIndex();
        }
        if (this.isEmptyStringQueryAllowed()) {
            sqlClause.allowEmptyStringQuery();
        }
        if (this.isInvalidQueryChecked()) {
            sqlClause.checkInvalidQuery();
        }
    }

    protected boolean isCurrentDBDef(DBDef currentDBDef) {
        return DBCurrent.getInstance().isCurrentDBDef(currentDBDef);
    }

    protected boolean isDisableSelectIndex() {
        return DBFluteConfig.getInstance().isDisableSelectIndex();
    }

    protected boolean isEmptyStringQueryAllowed() {
        return DBFluteConfig.getInstance().isEmptyStringQueryAllowed();
    }

    protected boolean isInvalidQueryChecked() {
        return DBFluteConfig.getInstance().isInvalidQueryChecked();
    }
}

