/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.view.designer;

import org.mobylet.core.util.StringUtils;
import org.mobylet.view.designer.SingletonDesigner;

public class OutDesigner
extends SingletonDesigner {
    public static final String AMP = "&amp;";
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String SQUOT = "&#39;";
    public static final String DQUOT = "&quot;";
    public static final String BR = "<br />";

    public String get(String value, boolean escapeXml, boolean breakToBr) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        String retStr = StringUtils.toHan(value);
        if (escapeXml) {
            retStr = this.doEscapeXml(retStr);
        }
        if (breakToBr) {
            retStr = this.doBreakToBr(retStr);
        }
        return retStr;
    }

    protected String doEscapeXml(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        char[] charArray = value.toCharArray();
        StringBuilder buf = new StringBuilder();
        block7: for (char c : charArray) {
            switch (c) {
                case '&': {
                    buf.append(AMP);
                    continue block7;
                }
                case '<': {
                    buf.append(LT);
                    continue block7;
                }
                case '>': {
                    buf.append(GT);
                    continue block7;
                }
                case '\'': {
                    buf.append(SQUOT);
                    continue block7;
                }
                case '\"': {
                    buf.append(DQUOT);
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected String doBreakToBr(String value) {
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        char[] charArray = value.toCharArray();
        StringBuilder buf = new StringBuilder();
        block4: for (char c : charArray) {
            switch (c) {
                case '\r': {
                    continue block4;
                }
                case '\n': {
                    buf.append(BR);
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }
}

