/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.analytics.impl;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.mobylet.core.analytics.AnalyticsHelper;
import org.mobylet.core.analytics.AnalyticsParameters;
import org.mobylet.core.analytics.impl.GoogleAnalyticsConfig;
import org.mobylet.core.log.MobyletLogger;
import org.mobylet.core.util.HttpUtils;
import org.mobylet.core.util.SingletonUtils;
import org.mobylet.core.util.StringUtils;

public class GoogleAnalyticsProcess
implements Runnable {
    protected AnalyticsParameters parameters;

    public GoogleAnalyticsProcess(AnalyticsParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public void run() {
        block3: {
            GoogleAnalyticsConfig config = SingletonUtils.get(GoogleAnalyticsConfig.class);
            AnalyticsHelper helper = SingletonUtils.get(AnalyticsHelper.class);
            String url = helper.getURL(this.parameters);
            if (StringUtils.isEmpty(url)) {
                return;
            }
            HttpURLConnection connection = HttpUtils.getHttpUrlConnection(url);
            connection.setRequestProperty("User-Agent", this.parameters.getCarrier().name());
            connection.setRequestProperty("Accept-Language", this.parameters.getUseLanguage());
            connection.setConnectTimeout(config.getConnectionTimeout());
            try {
                connection.connect();
                connection.getInputStream();
            }
            catch (IOException e) {
                MobyletLogger logger = SingletonUtils.get(MobyletLogger.class);
                if (logger == null || !logger.isLoggable()) break block3;
                logger.log("[mobylet] GoogleAnalytics\u3078\u306e\u901a\u4fe1\u51e6\u7406\u306b\u5931\u6557 = " + e.getMessage());
            }
        }
    }
}

