/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.Language;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.DetectedLanguage;
import org.apache.solr.update.processor.LanguageIdentifierUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class LangDetectLanguageIdentifierUpdateProcessor
extends LanguageIdentifierUpdateProcessor {
    public LangDetectLanguageIdentifierUpdateProcessor(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        super(req, rsp, next);
    }

    @Override
    protected List<DetectedLanguage> detectLanguage(String content) {
        if (content.trim().length() == 0) {
            log.debug("No input text to detect language from, returning empty list");
            return Collections.emptyList();
        }
        try {
            Detector detector = DetectorFactory.create();
            detector.append(content);
            ArrayList langlist = detector.getProbabilities();
            ArrayList<DetectedLanguage> solrLangList = new ArrayList<DetectedLanguage>();
            for (Language l : langlist) {
                solrLangList.add(new DetectedLanguage(l.lang, l.prob));
            }
            return solrLangList;
        }
        catch (LangDetectException e) {
            log.debug("Could not determine language, returning empty list: ", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

