/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import org.carrot2.core.LanguageCode;
import org.carrot2.text.linguistic.IStemmer;
import org.carrot2.text.linguistic.IStemmerFactory;
import org.carrot2.text.linguistic.IdentityStemmer;
import org.carrot2.text.linguistic.lucene.ArabicStemmerAdapter;
import org.carrot2.text.linguistic.lucene.SnowballStemmerFactory;
import org.carrot2.text.linguistic.morfologik.MorfologikStemmerAdapter;
import org.carrot2.util.annotations.ThreadSafe;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.factory.FallbackFactory;
import org.carrot2.util.factory.IFactory;
import org.carrot2.util.factory.NewClassInstanceFactory;
import org.carrot2.util.factory.SingletonFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable
@ThreadSafe
public class DefaultStemmerFactory
implements IStemmerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStemmerFactory.class);
    private static final EnumMap<LanguageCode, IFactory<IStemmer>> stemmerFactories;
    private static final Predicate<IStemmer> stemmerVerifier;

    @Override
    public IStemmer getStemmer(LanguageCode languageCode) {
        return stemmerFactories.get((Object)languageCode).createInstance();
    }

    private static EnumMap<LanguageCode, IFactory<IStemmer>> createDefaultStemmers() {
        SingletonFactory identity = new SingletonFactory(new IdentityStemmer());
        EnumMap map = Maps.newEnumMap(LanguageCode.class);
        map.put(LanguageCode.POLISH, new NewClassInstanceFactory<MorfologikStemmerAdapter>(MorfologikStemmerAdapter.class));
        map.put(LanguageCode.ARABIC, new NewClassInstanceFactory<ArabicStemmerAdapter>(ArabicStemmerAdapter.class));
        map.put(LanguageCode.DANISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.DanishStemmer"));
        map.put(LanguageCode.DUTCH, new SnowballStemmerFactory("org.tartarus.snowball.ext.DutchStemmer"));
        map.put(LanguageCode.ENGLISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.EnglishStemmer"));
        map.put(LanguageCode.FINNISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.FinnishStemmer"));
        map.put(LanguageCode.FRENCH, new SnowballStemmerFactory("org.tartarus.snowball.ext.FrenchStemmer"));
        map.put(LanguageCode.GERMAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.GermanStemmer"));
        map.put(LanguageCode.HUNGARIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.HungarianStemmer"));
        map.put(LanguageCode.ITALIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.ItalianStemmer"));
        map.put(LanguageCode.NORWEGIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.NorwegianStemmer"));
        map.put(LanguageCode.PORTUGUESE, new SnowballStemmerFactory("org.tartarus.snowball.ext.PortugueseStemmer"));
        map.put(LanguageCode.ROMANIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.RomanianStemmer"));
        map.put(LanguageCode.RUSSIAN, new SnowballStemmerFactory("org.tartarus.snowball.ext.RussianStemmer"));
        map.put(LanguageCode.SPANISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.SpanishStemmer"));
        map.put(LanguageCode.SWEDISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.SwedishStemmer"));
        map.put(LanguageCode.TURKISH, new SnowballStemmerFactory("org.tartarus.snowball.ext.TurkishStemmer"));
        map.put(LanguageCode.CHINESE_SIMPLIFIED, identity);
        for (LanguageCode lc : LanguageCode.values()) {
            if (map.containsKey((Object)lc)) {
                FallbackFactory<IStemmer> factory = (FallbackFactory<IStemmer>)map.get((Object)lc);
                if (factory == identity) continue;
                factory = new FallbackFactory<IStemmer>(factory, identity, stemmerVerifier, logger, "Stemmer for " + lc.toString() + " (" + lc.getIsoCode() + ") is not available." + " This may degrade clustering quality of " + lc.toString() + " content. Cause: {}");
                map.put(lc, factory);
                continue;
            }
            map.put(lc, identity);
        }
        return map;
    }

    static {
        stemmerVerifier = new Predicate<IStemmer>(){

            public boolean apply(IStemmer stemmer) {
                stemmer.stem("verification");
                return true;
            }
        };
        stemmerFactories = DefaultStemmerFactory.createDefaultStemmers();
    }
}

