/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.xpath.XPathExpressionException;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.core.CloserThread;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.ConfigSolrXml;
import org.apache.solr.core.ConfigSolrXmlOld;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCores;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.jul.JulWatcher;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.PropertiesUtil;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContainer {
    private static final String LEADER_VOTE_WAIT = "180000";
    private static final int CORE_LOAD_THREADS = 3;
    private static final int DEFAULT_ZK_CLIENT_TIMEOUT = 15000;
    public static final String DEFAULT_DEFAULT_CORE_NAME = "collection1";
    private static final boolean DEFAULT_SHARE_SCHEMA = false;
    protected static Logger log = LoggerFactory.getLogger(CoreContainer.class);
    private final SolrCores solrCores = new SolrCores(this);
    protected final Map<String, Exception> coreInitFailures = Collections.synchronizedMap(new LinkedHashMap());
    protected boolean persistent = false;
    protected String adminPath = null;
    protected volatile String managementPath = null;
    protected CoreAdminHandler coreAdminHandler = null;
    protected CollectionsHandler collectionsHandler = null;
    protected String libDir = null;
    protected Properties containerProperties;
    protected Map<String, IndexSchema> indexSchemaCache;
    protected String adminHandler;
    protected boolean shareSchema;
    protected Integer zkClientTimeout;
    protected String defaultCoreName = null;
    protected int distribUpdateConnTimeout = 0;
    protected int distribUpdateSoTimeout = 0;
    protected ZkContainer zkSys = new ZkContainer();
    private ShardHandlerFactory shardHandlerFactory;
    protected LogWatcher logging = null;
    private String zkHost;
    private int transientCacheSize = Integer.MAX_VALUE;
    private int coreLoadThreads;
    private CloserThread backgroundCloser = null;
    protected final ConfigSolr cfg;
    protected final SolrResourceLoader loader;
    protected final String solrHome;
    private volatile boolean isShutDown;

    public CoreContainer() {
        this(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
    }

    public CoreContainer(SolrResourceLoader loader) {
        this(loader, ConfigSolr.fromSolrHome(loader, loader.getInstanceDir()));
    }

    public CoreContainer(String solrHome) {
        this(new SolrResourceLoader(solrHome));
    }

    public CoreContainer(SolrResourceLoader loader, ConfigSolr config) {
        log.info("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.loader = (SolrResourceLoader)Preconditions.checkNotNull((Object)loader);
        this.solrHome = loader.getInstanceDir();
        this.cfg = (ConfigSolr)Preconditions.checkNotNull((Object)config);
    }

    public static CoreContainer createAndLoad(String solrHome, File configFile) {
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        CoreContainer cc = new CoreContainer(loader, ConfigSolr.fromFile(loader, configFile));
        cc.load();
        return cc;
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        log.info("Loading cores into CoreContainer [instanceDir={}]", (Object)this.loader.getInstanceDir());
        ThreadPoolExecutor coreLoadExecutor = null;
        this.libDir = this.cfg.get(ConfigSolr.CfgProp.SOLR_SHAREDLIB, null);
        if (this.libDir != null) {
            File f = FileUtils.resolvePath(new File(this.solrHome), this.libDir);
            log.info("loading shared library: " + f.getAbsolutePath());
            this.loader.addToClassLoader(this.libDir, null, false);
            this.loader.reloadLuceneSPI();
        }
        this.shardHandlerFactory = ShardHandlerFactory.newInstance(this.cfg.getShardHandlerFactoryPluginInfo(), this.loader);
        this.solrCores.allocateLazyCores(this.cfg, this.loader);
        this.logging = JulWatcher.newRegisteredLogWatcher(this.cfg, this.loader);
        if (this.cfg instanceof ConfigSolrXmlOld) {
            String dcoreName = this.cfg.get(ConfigSolr.CfgProp.SOLR_CORES_DEFAULT_CORE_NAME, null);
            if (dcoreName != null && !dcoreName.isEmpty()) {
                this.defaultCoreName = dcoreName;
            }
            this.persistent = this.cfg.getBool(ConfigSolr.CfgProp.SOLR_PERSISTENT, false);
            this.adminPath = this.cfg.get(ConfigSolr.CfgProp.SOLR_ADMINPATH, "/admin/cores");
        } else {
            this.adminPath = "/admin/cores";
            this.defaultCoreName = DEFAULT_DEFAULT_CORE_NAME;
        }
        this.zkHost = this.cfg.get(ConfigSolr.CfgProp.SOLR_ZKHOST, null);
        this.coreLoadThreads = this.cfg.getInt(ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, 3);
        this.shareSchema = this.cfg.getBool(ConfigSolr.CfgProp.SOLR_SHARESCHEMA, false);
        this.zkClientTimeout = this.cfg.getInt(ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, 15000);
        this.distribUpdateConnTimeout = this.cfg.getInt(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, 0);
        this.distribUpdateSoTimeout = this.cfg.getInt(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, 0);
        String hostPort = this.cfg.get(ConfigSolr.CfgProp.SOLR_HOSTPORT, null);
        String hostContext = this.cfg.get(ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, null);
        String host = this.cfg.get(ConfigSolr.CfgProp.SOLR_HOST, null);
        String leaderVoteWait = this.cfg.get(ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, LEADER_VOTE_WAIT);
        this.adminHandler = this.cfg.get(ConfigSolr.CfgProp.SOLR_ADMINHANDLER, null);
        this.managementPath = this.cfg.get(ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, null);
        this.transientCacheSize = this.cfg.getInt(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, Integer.MAX_VALUE);
        boolean genericCoreNodeNames = this.cfg.getBool(ConfigSolr.CfgProp.SOLR_GENERICCORENODENAMES, false);
        if (this.shareSchema) {
            this.indexSchemaCache = new ConcurrentHashMap<String, IndexSchema>();
        }
        this.zkClientTimeout = Integer.parseInt(System.getProperty("zkClientTimeout", Integer.toString(this.zkClientTimeout)));
        this.zkSys.initZooKeeper(this, this.solrHome, this.zkHost, this.zkClientTimeout, hostPort, hostContext, host, leaderVoteWait, genericCoreNodeNames, this.distribUpdateConnTimeout, this.distribUpdateSoTimeout);
        if (this.isZooKeeperAware() && this.coreLoadThreads <= 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCloud requires a value of at least 2 in solr.xml for coreLoadThreads");
        }
        if (this.adminPath != null) {
            this.coreAdminHandler = this.adminHandler == null ? new CoreAdminHandler(this) : this.createMultiCoreHandler(this.adminHandler);
        }
        this.collectionsHandler = new CollectionsHandler(this);
        this.containerProperties = this.cfg.getSolrProperties("solr");
        coreLoadExecutor = new ThreadPoolExecutor(this.coreLoadThreads, this.coreLoadThreads, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultSolrThreadFactory("coreLoadExecutor"));
        try {
            ExecutorCompletionService<SolrCore> completionService = new ExecutorCompletionService<SolrCore>(coreLoadExecutor);
            HashSet<Future<SolrCore>> pending = new HashSet<Future<SolrCore>>();
            List<String> allCores = this.cfg.getAllCoreNames();
            for (String oneCoreName : allCores) {
                try {
                    String rawName = this.cfg.getProperty(oneCoreName, "name", null);
                    if (null == rawName) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each core in solr.xml must have a 'name'");
                    }
                    final String name = rawName;
                    final CoreDescriptor p = new CoreDescriptor(this, name, this.cfg.getProperty(oneCoreName, "instanceDir", null));
                    String opt = this.cfg.getProperty(oneCoreName, "config", null);
                    if (opt != null) {
                        p.setConfigName(opt);
                    }
                    if ((opt = this.cfg.getProperty(oneCoreName, "schema", null)) != null) {
                        p.setSchemaName(opt);
                    }
                    if (this.zkSys.getZkController() != null) {
                        opt = this.cfg.getProperty(oneCoreName, "shard", null);
                        if (opt != null && opt.length() > 0) {
                            p.getCloudDescriptor().setShardId(opt);
                        }
                        if ((opt = this.cfg.getProperty(oneCoreName, "collection", null)) != null) {
                            p.getCloudDescriptor().setCollectionName(opt);
                        }
                        if ((opt = this.cfg.getProperty(oneCoreName, "roles", null)) != null) {
                            p.getCloudDescriptor().setRoles(opt);
                        }
                        if ((opt = this.cfg.getProperty(oneCoreName, "coreNodeName", null)) != null && opt.length() > 0) {
                            p.getCloudDescriptor().setCoreNodeName(opt);
                        }
                    }
                    if ((opt = this.cfg.getProperty(oneCoreName, "properties", null)) != null) {
                        p.setPropertiesName(opt);
                    }
                    if ((opt = this.cfg.getProperty(oneCoreName, "dataDir", null)) != null) {
                        p.setDataDir(opt);
                    }
                    p.setCoreProperties(this.cfg.readCoreProperties(oneCoreName));
                    opt = this.cfg.getProperty(oneCoreName, "loadOnStartup", null);
                    if (opt != null) {
                        p.setLoadOnStartup("true".equalsIgnoreCase(opt) || "on".equalsIgnoreCase(opt));
                    }
                    if ((opt = this.cfg.getProperty(oneCoreName, "transient", null)) != null) {
                        p.setTransient("true".equalsIgnoreCase(opt) || "on".equalsIgnoreCase(opt));
                    }
                    if (p.isTransient() || !p.isLoadOnStartup()) {
                        this.solrCores.putDynamicDescriptor(rawName, p);
                    }
                    if (!p.isLoadOnStartup()) continue;
                    Callable<SolrCore> task = new Callable<SolrCore>(){

                        @Override
                        public SolrCore call() {
                            SolrCore c;
                            block8: {
                                c = null;
                                try {
                                    if (CoreContainer.this.zkSys.getZkController() != null) {
                                        CoreContainer.this.preRegisterInZk(p);
                                    }
                                    c = CoreContainer.this.create(p);
                                    CoreContainer.this.registerCore(p.isTransient(), name, c, false);
                                }
                                catch (Throwable t) {
                                    if (CoreContainer.this.isZooKeeperAware()) {
                                        try {
                                            CoreContainer.this.zkSys.zkController.unregister(name, p);
                                        }
                                        catch (InterruptedException e) {
                                            Thread.currentThread().interrupt();
                                            SolrException.log((Logger)log, null, (Throwable)e);
                                        }
                                        catch (KeeperException e) {
                                            SolrException.log((Logger)log, null, (Throwable)e);
                                        }
                                    }
                                    SolrException.log((Logger)log, null, (Throwable)t);
                                    if (c == null) break block8;
                                    c.close();
                                }
                            }
                            return c;
                        }
                    };
                    pending.add(completionService.submit(task));
                }
                catch (Throwable ex) {
                    SolrException.log((Logger)log, null, (Throwable)ex);
                }
            }
            while (pending != null && pending.size() > 0) {
                Future future;
                block34: {
                    try {
                        future = completionService.take();
                        if (future != null) break block34;
                        return;
                    }
                    catch (InterruptedException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "interrupted while loading core", (Throwable)e);
                    }
                }
                pending.remove(future);
                try {
                    SolrCore c = (SolrCore)future.get();
                    if (c == null) continue;
                    this.solrCores.putCoreToOrigName(c, c.getName());
                }
                catch (ExecutionException e) {
                    SolrException.log((Logger)SolrCore.log, (String)"Error loading core", (Throwable)e);
                }
            }
            this.backgroundCloser = new CloserThread(this, this.solrCores, this.cfg);
            this.backgroundCloser.start();
        }
        finally {
            if (coreLoadExecutor != null) {
                ExecutorUtil.shutdownNowAndAwaitTermination((ExecutorService)coreLoadExecutor);
            }
        }
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        log.info("Shutting down CoreContainer instance=" + System.identityHashCode(this));
        if (this.isZooKeeperAware()) {
            try {
                this.zkSys.getZkController().publishAndWaitForDownStates();
            }
            catch (KeeperException e) {
                log.error("", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("", (Throwable)e);
            }
        }
        this.isShutDown = true;
        if (this.isZooKeeperAware()) {
            this.zkSys.publishCoresAsDown(this.solrCores.getCores());
            this.cancelCoreRecoveries();
        }
        try {
            block18: {
                Object e = this.solrCores.getModifyLock();
                synchronized (e) {
                    this.solrCores.getModifyLock().notifyAll();
                }
                if (this.backgroundCloser != null) {
                    try {
                        this.backgroundCloser.join();
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        if (!log.isDebugEnabled()) break block18;
                        log.debug("backgroundCloser thread was interrupted before finishing");
                    }
                }
            }
            this.solrCores.close();
            Object object = this.solrCores.getModifyLock();
            synchronized (object) {
                this.solrCores.getModifyLock().notifyAll();
            }
        }
        finally {
            if (this.shardHandlerFactory != null) {
                this.shardHandlerFactory.close();
            }
            this.zkSys.close();
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.loader});
    }

    public void cancelCoreRecoveries() {
        List<SolrCore> cores = this.solrCores.getCores();
        for (SolrCore core : cores) {
            try {
                core.getSolrCoreState().cancelRecovery();
            }
            catch (Throwable t) {
                SolrException.log((Logger)log, (String)"Error canceling recovery for core", (Throwable)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not shutdown prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance=" + System.identityHashCode(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore registerCore(boolean isTransientCore, String name, SolrCore core, boolean returnPrevNotClosed) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (name == null || name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            throw new RuntimeException("Invalid core name: " + name);
        }
        SolrCore old = null;
        if (this.isShutDown) {
            core.close();
            throw new IllegalStateException("This CoreContainer has been shutdown");
        }
        old = isTransientCore ? this.solrCores.putTransientCore(this.cfg, name, core, this.loader) : this.solrCores.putCore(name, core);
        core.setName(name);
        core.getCoreDescriptor().putProperty("name", name);
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            this.coreInitFailures.remove(name);
        }
        if (old == null || old == core) {
            log.info("registering core: " + name);
            this.zkSys.registerInZk(core);
            return null;
        }
        log.info("replacing core: " + name);
        if (!returnPrevNotClosed) {
            old.close();
        }
        this.zkSys.registerInZk(core);
        return old;
    }

    public SolrCore register(SolrCore core, boolean returnPrev) {
        return this.registerCore(false, core.getName(), core, returnPrev);
    }

    public SolrCore register(String name, SolrCore core, boolean returnPrev) {
        return this.registerCore(false, name, core, returnPrev);
    }

    private SolrCore createFromLocal(String instanceDir, CoreDescriptor dcore) {
        SolrCore core;
        SolrResourceLoader solrLoader = null;
        SolrConfig config = null;
        solrLoader = new SolrResourceLoader(instanceDir, this.loader.getClassLoader(), ConfigSolrXml.getCoreProperties(instanceDir, dcore));
        try {
            config = new SolrConfig(solrLoader, dcore.getConfigName(), null);
        }
        catch (Exception e) {
            log.error("Failed to load file {}", (Object)new File(instanceDir, dcore.getConfigName()).getAbsolutePath());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load config for " + dcore.getConfigName(), (Throwable)e);
        }
        IndexSchema schema = null;
        if (this.indexSchemaCache != null) {
            String resourceNameToBeUsed = IndexSchemaFactory.getResourceNameToBeUsed(dcore.getSchemaName(), config);
            File schemaFile = new File(resourceNameToBeUsed);
            if (!schemaFile.isAbsolute()) {
                schemaFile = new File(solrLoader.getConfigDir(), schemaFile.getPath());
            }
            if (schemaFile.exists()) {
                String key = schemaFile.getAbsolutePath() + ":" + new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT).format(new Date(schemaFile.lastModified()));
                schema = this.indexSchemaCache.get(key);
                if (schema == null) {
                    log.info("creating new schema object for core: " + dcore.getProperty("name"));
                    schema = IndexSchemaFactory.buildIndexSchema(dcore.getSchemaName(), config);
                    this.indexSchemaCache.put(key, schema);
                } else {
                    log.info("re-using schema object for core: " + dcore.getProperty("name"));
                }
            }
        }
        if (schema == null) {
            schema = IndexSchemaFactory.buildIndexSchema(dcore.getSchemaName(), config);
        }
        if ((core = new SolrCore(dcore.getName(), null, config, schema, dcore)).getUpdateHandler().getUpdateLog() != null) {
            core.getUpdateHandler().getUpdateLog().recoverFromLog();
        }
        return core;
    }

    public SolrCore create(CoreDescriptor dcore) {
        if (this.isShutDown) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Solr has shutdown.");
        }
        String name = dcore.getName();
        try {
            File idir = new File(dcore.getInstanceDir());
            String instanceDir = idir.getPath();
            log.info("Creating SolrCore '{}' using instanceDir: {}", (Object)dcore.getName(), (Object)instanceDir);
            SolrCore created = null;
            created = this.zkSys.getZkController() != null ? this.zkSys.createFromZk(instanceDir, dcore, this.loader) : this.createFromLocal(instanceDir, dcore);
            this.solrCores.addCreated(created);
            return created;
        }
        catch (Exception ex) {
            throw this.recordAndThrow(name, "Unable to create core: " + name, ex);
        }
    }

    public Collection<SolrCore> getCores() {
        return this.solrCores.getCores();
    }

    public Collection<String> getCoreNames() {
        return this.solrCores.getCoreNames();
    }

    public Collection<String> getCoreNames(SolrCore core) {
        return this.solrCores.getCoreNames(core);
    }

    public Collection<String> getAllCoreNames() {
        return this.solrCores.getAllCoreNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Exception> getCoreInitFailures() {
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            return Collections.unmodifiableMap(new LinkedHashMap<String, Exception>(this.coreInitFailures));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String name) {
        try {
            name = this.checkDefault(name);
            SolrCore core = this.solrCores.getCoreFromAnyList(name, false);
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
            }
            try {
                SolrResourceLoader solrLoader;
                this.solrCores.waitAddPendingCoreOps(name);
                CoreDescriptor cd = core.getCoreDescriptor();
                File instanceDir = new File(cd.getInstanceDir());
                log.info("Reloading SolrCore '{}' using instanceDir: {}", (Object)cd.getName(), (Object)instanceDir.getAbsolutePath());
                if (this.zkSys.getZkController() == null) {
                    solrLoader = new SolrResourceLoader(instanceDir.getAbsolutePath(), this.loader.getClassLoader(), ConfigSolrXml.getCoreProperties(instanceDir.getAbsolutePath(), cd));
                } else {
                    try {
                        String collection = cd.getCloudDescriptor().getCollectionName();
                        this.zkSys.getZkController().createCollectionZkNode(cd.getCloudDescriptor());
                        String zkConfigName = this.zkSys.getZkController().readConfigName(collection);
                        if (zkConfigName == null) {
                            log.error("Could not find config name for collection:" + collection);
                            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Could not find config name for collection:" + collection);
                        }
                        solrLoader = new ZkSolrResourceLoader(instanceDir.getAbsolutePath(), zkConfigName, this.loader.getClassLoader(), ConfigSolrXml.getCoreProperties(instanceDir.getAbsolutePath(), cd), this.zkSys.getZkController());
                    }
                    catch (KeeperException e) {
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        log.error("", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                    }
                }
                SolrCore newCore = core.reload(solrLoader, core);
                this.solrCores.removeCoreToOrigName(newCore, core);
                this.registerCore(false, name, newCore, false);
            }
            finally {
                this.solrCores.removeFromPendingOps(name);
            }
        }
        catch (Exception ex) {
            throw this.recordAndThrow(name, "Unable to reload core: " + name, ex);
        }
    }

    private String checkDefault(String name) {
        return null == name || name.isEmpty() ? this.defaultCoreName : name;
    }

    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        n0 = this.checkDefault(n0);
        n1 = this.checkDefault(n1);
        this.solrCores.swap(n0, n1);
        log.info("swapped: " + n0 + " with " + n1);
    }

    public SolrCore remove(String name) {
        name = this.checkDefault(name);
        return this.solrCores.remove(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String name, String toName) {
        SolrCore core = this.getCore(name);
        try {
            if (core != null) {
                this.registerCore(false, toName, core, false);
                name = this.checkDefault(name);
                this.solrCores.remove(name, false);
            }
        }
        finally {
            if (core != null) {
                core.close();
            }
        }
    }

    public SolrCore getCore(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name = this.checkDefault(name), true);
        if (core != null) {
            return core;
        }
        CoreDescriptor desc = this.solrCores.getDynamicDescriptor(name);
        if (desc == null) {
            Exception e = this.getCoreInitFailures().get(name);
            if (null != e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "SolrCore '" + name + "' is not available due to init failure: " + e.getMessage(), (Throwable)e);
            }
            return null;
        }
        core = this.solrCores.waitAddPendingCoreOps(name);
        if (this.isShutDown) {
            return null;
        }
        try {
            if (core == null) {
                if (this.zkSys.getZkController() != null) {
                    this.preRegisterInZk(desc);
                }
                core = this.create(desc);
                core.open();
                this.registerCore(desc.isTransient(), name, core, false);
            } else {
                core.open();
            }
        }
        catch (Exception ex) {
            if (this.isZooKeeperAware()) {
                try {
                    this.getZkController().unregister(name, desc);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SolrException.log((Logger)log, null, (Throwable)e);
                }
                catch (KeeperException e) {
                    SolrException.log((Logger)log, null, (Throwable)e);
                }
            }
            throw this.recordAndThrow(name, "Unable to create core: " + name, ex);
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
        return core;
    }

    protected CoreAdminHandler createMultiCoreHandler(String adminHandlerClass) {
        return this.loader.newAdminHandlerInstance(this, adminHandlerClass, new String[0]);
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public String getDefaultCoreName() {
        return this.defaultCoreName;
    }

    @Deprecated
    public boolean isPersistent() {
        return this.persistent;
    }

    @Deprecated
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getAdminPath() {
        return this.adminPath;
    }

    public String getManagementPath() {
        return this.managementPath;
    }

    public void setManagementPath(String path) {
        this.managementPath = path;
    }

    public LogWatcher getLogging() {
        return this.logging;
    }

    public void setLogging(LogWatcher v) {
        this.logging = v;
    }

    public File getConfigFile() {
        return new File(this.solrHome, "solr.xml");
    }

    public boolean isLoaded(String name) {
        return this.solrCores.isLoaded(name);
    }

    @Deprecated
    public void persist() {
        this.persistFile(this.getConfigFile());
    }

    public CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        return this.solrCores.getUnloadedCoreDescriptor(cname);
    }

    @Deprecated
    public void persistFile(File file) {
        assert (file != null);
        if (this.cfg != null && !(this.cfg instanceof ConfigSolrXmlOld)) {
            return;
        }
        log.info("Persisting cores config to " + (file == null ? this.getConfigFile() : file));
        HashMap<String, String> rootSolrAttribs = new HashMap<String, String>();
        this.addAttrib(rootSolrAttribs, ConfigSolr.CfgProp.SOLR_SHAREDLIB, "sharedLib", this.libDir);
        this.addAttrib(rootSolrAttribs, ConfigSolr.CfgProp.SOLR_PERSISTENT, "persistent", Boolean.toString(this.isPersistent()), "false");
        this.addAttrib(rootSolrAttribs, ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, "coreLoadThreads", Integer.toString(this.coreLoadThreads), Integer.toString(3));
        this.addAttrib(rootSolrAttribs, ConfigSolr.CfgProp.SOLR_ZKHOST, "zkHost", this.zkHost);
        HashMap<String, String> coresAttribs = new HashMap<String, String>();
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_ADMINPATH, "adminPath", this.adminPath, this.getAdminPath());
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_ADMINHANDLER, "adminHandler", this.adminHandler);
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_SHARESCHEMA, "shareSchema", Boolean.toString(this.shareSchema), Boolean.toString(false));
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_HOST, "host", this.zkSys.getHost());
        if (null != this.defaultCoreName && !this.defaultCoreName.equals("")) {
            coresAttribs.put("defaultCoreName", this.defaultCoreName);
        }
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_HOSTPORT, "hostPort", this.zkSys.getHostPort());
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, "zkClientTimeout", this.intToString(this.zkClientTimeout), Integer.toString(15000));
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, "hostContext", this.zkSys.getHostContext());
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, "leaderVoteWait", this.zkSys.getLeaderVoteWait(), LEADER_VOTE_WAIT);
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_GENERICCORENODENAMES, "genericCoreNodeNames", Boolean.toString(this.zkSys.getGenericCoreNodeNames()), "false");
        if (this.transientCacheSize != Integer.MAX_VALUE) {
            this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, "transientCacheSize", Integer.toString(this.transientCacheSize), Integer.toString(Integer.MAX_VALUE));
        }
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, "distribUpdateConnTimeout", Integer.toString(this.distribUpdateConnTimeout), Integer.toString(this.distribUpdateConnTimeout));
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, "distribUpdateSoTimeout", Integer.toString(this.distribUpdateSoTimeout), Integer.toString(this.distribUpdateSoTimeout));
        this.addAttrib(coresAttribs, ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, "managementPath", this.managementPath);
        HashMap<String, String> loggingAttribs = new HashMap<String, String>();
        this.addAttrib(loggingAttribs, ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, "class", this.cfg.get(ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, null));
        this.addAttrib(loggingAttribs, ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, "enabled", this.cfg.get(ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, null));
        HashMap<String, String> watcherAttribs = new HashMap<String, String>();
        this.addAttrib(watcherAttribs, ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, "size", this.cfg.get(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, null));
        this.addAttrib(watcherAttribs, ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, "threshold", this.cfg.get(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, null));
        try {
            this.solrCores.persistCores(this.cfg.config.getOriginalConfig(), this.containerProperties, rootSolrAttribs, coresAttribs, loggingAttribs, watcherAttribs, this.cfg.getUnsubsititutedShardHandlerFactoryPluginNode(), file, this.loader);
        }
        catch (XPathExpressionException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, null, (Throwable)e);
        }
    }

    private String intToString(Integer integer) {
        if (integer == null) {
            return null;
        }
        return Integer.toString(integer);
    }

    private void addAttrib(Map<String, String> attribs, ConfigSolr.CfgProp prop, String attribName, String attribValue) {
        this.addAttrib(attribs, prop, attribName, attribValue, null);
    }

    private void addAttrib(Map<String, String> attribs, ConfigSolr.CfgProp prop, String attribName, String attribValue, String defaultValue) {
        if (this.cfg == null) {
            attribs.put(attribName, attribValue);
            return;
        }
        if (attribValue != null) {
            String origValue = this.cfg.getOrigProp(prop, null);
            if (origValue == null && defaultValue != null && attribValue.equals(defaultValue)) {
                return;
            }
            if (attribValue.equals(PropertiesUtil.substituteProperty(origValue, this.loader.getCoreProperties()))) {
                attribs.put(attribName, origValue);
            } else {
                attribs.put(attribName, attribValue);
            }
        }
    }

    public void preRegisterInZk(CoreDescriptor p) {
        this.zkSys.getZkController().preRegister(p);
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public boolean isZooKeeperAware() {
        return this.zkSys.getZkController() != null;
    }

    public ZkController getZkController() {
        return this.zkSys.getZkController();
    }

    public boolean isShareSchema() {
        return this.shareSchema;
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SolrException recordAndThrow(String name, String msg, Exception ex) {
        Map<String, Exception> map = this.coreInitFailures;
        synchronized (map) {
            this.coreInitFailures.remove(name);
            this.coreInitFailures.put(name, ex);
        }
        log.error(msg, (Throwable)ex);
        return new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg, (Throwable)ex);
    }

    String getCoreToOrigName(SolrCore core) {
        return this.solrCores.getCoreToOrigName(core);
    }
}

