/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCores;

class CloserThread
extends Thread {
    CoreContainer container;
    SolrCores solrCores;
    ConfigSolr cfg;

    CloserThread(CoreContainer container, SolrCores solrCores, ConfigSolr cfg) {
        this.container = container;
        this.solrCores = solrCores;
        this.cfg = cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.container.isShutDown()) {
            Object object = this.solrCores.getModifyLock();
            synchronized (object) {
                try {
                    this.solrCores.getModifyLock().wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            SolrCore removeMe = this.solrCores.getCoreToClose();
            while (removeMe != null && !this.container.isShutDown()) {
                try {
                    removeMe.close();
                }
                finally {
                    this.solrCores.removeFromPendingOps(removeMe.getName());
                }
                removeMe = this.solrCores.getCoreToClose();
            }
        }
    }
}

