/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.dangan.util.lha.PreLz5Decoder;
import jp.gr.java_conf.dangan.util.lha.PreLzssDecoder;

public class LzssInputStream
extends InputStream {
    private PreLzssDecoder decoder;
    private int Threshold;
    private int MaxMatch;
    private long Length;
    private byte[] TextBuffer;
    private long TextPosition;
    private long TextDecoded;
    private byte[] MarkTextBuffer;
    private long MarkTextPosition;
    private long MarkTextDecoded;

    private LzssInputStream() {
    }

    public LzssInputStream(PreLzssDecoder preLzssDecoder) {
        this(preLzssDecoder, Long.MAX_VALUE);
    }

    public LzssInputStream(PreLzssDecoder preLzssDecoder, long l) {
        this.MaxMatch = preLzssDecoder.getMaxMatch();
        this.Threshold = preLzssDecoder.getThreshold();
        this.Length = l;
        this.decoder = preLzssDecoder;
        this.TextBuffer = new byte[preLzssDecoder.getDictionarySize()];
        this.TextPosition = 0L;
        this.TextDecoded = 0L;
        if (this.decoder instanceof PreLz5Decoder) {
            this.initLz5TextBuffer();
        }
    }

    public int read() throws IOException {
        block3: {
            if (this.TextDecoded <= this.TextPosition) {
                try {
                    this.decode();
                }
                catch (EOFException eOFException) {
                    if (this.TextDecoded > this.TextPosition) break block3;
                    return -1;
                }
            }
        }
        return this.TextBuffer[(int)this.TextPosition++ & this.TextBuffer.length - 1] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block4: {
            n3 = n;
            int n4 = n + n2;
            try {
                while (n3 < n4) {
                    if (this.TextDecoded <= this.TextPosition) {
                        this.decode();
                    }
                    n3 = this.copyTextBufferToBuffer(byArray, n3, n4);
                }
            }
            catch (EOFException eOFException) {
                n3 = this.copyTextBufferToBuffer(byArray, n3, n4);
                if (n3 != n) break block4;
                return -1;
            }
        }
        return n3 - n;
    }

    public long skip(long l) throws IOException {
        long l2 = this.TextPosition + l;
        try {
            while (this.TextPosition < l2) {
                if (this.TextDecoded <= this.TextPosition) {
                    this.decode();
                }
                this.TextPosition = Math.min(l2, this.TextDecoded);
            }
        }
        catch (EOFException eOFException) {
            this.TextPosition = Math.min(l2, this.TextDecoded);
        }
        return l - (l2 - this.TextPosition);
    }

    public void mark(int n) {
        n -= (int)(this.TextDecoded - this.TextPosition);
        int n2 = this.TextBuffer.length - this.MaxMatch;
        n = (n + n2 - 1) / n2 * n2;
        this.decoder.mark(Math.max(n, 0));
        if (this.MarkTextBuffer == null) {
            this.MarkTextBuffer = (byte[])this.TextBuffer.clone();
        } else {
            System.arraycopy(this.TextBuffer, 0, this.MarkTextBuffer, 0, this.TextBuffer.length);
        }
        this.MarkTextPosition = this.TextPosition;
        this.MarkTextDecoded = this.TextDecoded;
    }

    public void reset() throws IOException {
        if (this.MarkTextBuffer == null) {
            throw new IOException("not marked.");
        }
        if (this.TextDecoded - this.MarkTextPosition <= (long)this.TextBuffer.length) {
            this.TextPosition = this.MarkTextPosition;
        } else if (this.decoder.markSupported()) {
            this.decoder.reset();
            System.arraycopy(this.MarkTextBuffer, 0, this.TextBuffer, 0, this.TextBuffer.length);
            this.TextPosition = this.MarkTextPosition;
            this.TextDecoded = this.MarkTextDecoded;
        } else {
            throw new IOException("mark/reset not supported.");
        }
    }

    public boolean markSupported() {
        return this.decoder.markSupported();
    }

    public int available() throws IOException {
        return (int)(this.TextDecoded - this.TextPosition) + this.decoder.available();
    }

    public void close() throws IOException {
        this.decoder.close();
        this.decoder = null;
        this.TextBuffer = null;
        this.MarkTextBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode() throws IOException {
        if (this.TextDecoded < this.Length) {
            int n;
            int n2 = this.TextBuffer.length - 1;
            int n3 = n = (int)this.TextDecoded & n2;
            int n4 = (int)(Math.min(this.TextPosition + (long)this.TextBuffer.length - (long)this.MaxMatch, this.Length) - this.TextDecoded) + n;
            try {
                while (n3 < n4) {
                    int n5 = this.decoder.readCode();
                    if (n5 < 256) {
                        this.TextBuffer[n2 & n3++] = (byte)n5;
                        continue;
                    }
                    int n6 = (n5 & 0xFF) + this.Threshold;
                    int n7 = n3 - this.decoder.readOffset() - 1;
                    while (0 < n6--) {
                        this.TextBuffer[n2 & n3++] = this.TextBuffer[n2 & n7++];
                    }
                }
            }
            finally {
                this.TextDecoded += (long)(n3 - n);
            }
        } else {
            throw new EOFException();
        }
    }

    private int copyTextBufferToBuffer(byte[] byArray, int n, int n2) {
        int n3;
        if ((this.TextPosition & (long)(~(this.TextBuffer.length - 1))) < (this.TextDecoded & (long)(~(this.TextBuffer.length - 1)))) {
            n3 = Math.min(this.TextBuffer.length - ((int)this.TextPosition & this.TextBuffer.length - 1), n2 - n);
            System.arraycopy(this.TextBuffer, (int)this.TextPosition & this.TextBuffer.length - 1, byArray, n, n3);
            this.TextPosition += (long)n3;
            n += n3;
        }
        if (this.TextPosition < this.TextDecoded) {
            n3 = Math.min((int)(this.TextDecoded - this.TextPosition), n2 - n);
            System.arraycopy(this.TextBuffer, (int)this.TextPosition & this.TextBuffer.length - 1, byArray, n, n3);
            this.TextPosition += (long)n3;
            n += n3;
        }
        return n;
    }

    private void initLz5TextBuffer() {
        int n;
        int n2 = 18;
        for (n = 0; n < 256; ++n) {
            for (int i = 0; i < 13; ++i) {
                this.TextBuffer[n2++] = (byte)n;
            }
        }
        for (n = 0; n < 256; ++n) {
            this.TextBuffer[n2++] = (byte)n;
        }
        for (n = 0; n < 256; ++n) {
            this.TextBuffer[n2++] = (byte)(255 - n);
        }
        for (n = 0; n < 128; ++n) {
            this.TextBuffer[n2++] = 0;
        }
        while (n2 < this.TextBuffer.length) {
            this.TextBuffer[n2++] = 32;
        }
    }
}

