/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jp.gr.java_conf.dangan.lang.reflect.Type;

public class Factory {
    private Factory() {
    }

    public static Object createInstance(String string, Object[] objectArray) throws InvocationTargetException, InstantiationException, ClassNotFoundException, NoSuchMethodException {
        return Factory.createInstance(Class.forName(string), objectArray);
    }

    public static Object createInstance(Class clazz, Object[] objectArray) throws InvocationTargetException, InstantiationException, NoSuchMethodException {
        Constructor constructor = Factory.getMatchFullConstructor(clazz, objectArray);
        if (constructor == null && (constructor = Factory.getConstructor(clazz, objectArray)) != null) {
            objectArray = Type.parseAll(constructor.getParameterTypes(), objectArray);
        }
        if (constructor != null) {
            try {
                return constructor.newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError(illegalAccessException.toString());
            }
        }
        throw new NoSuchMethodException();
    }

    public static Constructor getConstructor(String string, Object[] objectArray) throws ClassNotFoundException {
        return Factory.getConstructor(Class.forName(string), objectArray);
    }

    public static Constructor getConstructor(Class clazz, Object[] objectArray) {
        return Factory.getConstructor(clazz, objectArray, false);
    }

    public static Constructor getConstructor(String string, Object[] objectArray, boolean bl) throws ClassNotFoundException {
        return Factory.getConstructor(Class.forName(string), objectArray, bl);
    }

    public static Constructor getConstructor(Class clazz, Object[] objectArray, boolean bl) {
        int n;
        Constructor<?>[] constructorArray = bl ? clazz.getDeclaredConstructors() : clazz.getConstructors();
        for (n = 0; n < constructorArray.length; ++n) {
            if (!Type.matchFullAll(constructorArray[n].getParameterTypes(), objectArray)) continue;
            return constructorArray[n];
        }
        for (n = 0; n < constructorArray.length; ++n) {
            if (!Type.matchRestrictAll(constructorArray[n].getParameterTypes(), objectArray)) continue;
            return constructorArray[n];
        }
        for (n = 0; n < constructorArray.length; ++n) {
            if (!Type.matchAll(constructorArray[n].getParameterTypes(), objectArray)) continue;
            return constructorArray[n];
        }
        return null;
    }

    public static Constructor getMatchFullConstructor(String string, Object[] objectArray) throws ClassNotFoundException {
        return Factory.getMatchFullConstructor(Class.forName(string), objectArray);
    }

    public static Constructor getMatchFullConstructor(Class clazz, Object[] objectArray) {
        return Factory.getMatchFullConstructor(clazz, objectArray, false);
    }

    public static Constructor getMatchFullConstructor(String string, Object[] objectArray, boolean bl) throws ClassNotFoundException {
        return Factory.getMatchFullConstructor(Class.forName(string), objectArray, bl);
    }

    public static Constructor getMatchFullConstructor(Class clazz, Object[] objectArray, boolean bl) {
        Constructor<?>[] constructorArray = bl ? clazz.getDeclaredConstructors() : clazz.getConstructors();
        for (int i = 0; i < constructorArray.length; ++i) {
            if (!Type.matchFullAll(constructorArray[i].getParameterTypes(), objectArray)) continue;
            return constructorArray[i];
        }
        return null;
    }
}

