/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.JavaBinUpdateRequestCodec;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.util.ContentStream;

public class BinaryRequestWriter
extends RequestWriter {
    @Override
    public Collection<ContentStream> getContentStreams(SolrRequest req) throws IOException {
        if (req instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)req;
            if (this.isNull(updateRequest.getDocuments()) && this.isNull(updateRequest.getDeleteById()) && this.isNull(updateRequest.getDeleteQuery()) && updateRequest.getDocIterator() == null) {
                return null;
            }
            ArrayList<ContentStream> l = new ArrayList<ContentStream>();
            l.add(new RequestWriter.LazyContentStream(this, updateRequest));
            return l;
        }
        return super.getContentStreams(req);
    }

    @Override
    public String getUpdateContentType() {
        return "application/javabin";
    }

    @Override
    public ContentStream getContentStream(UpdateRequest request) throws IOException {
        final BAOS baos = new BAOS();
        new JavaBinUpdateRequestCodec().marshal(request, baos);
        return new ContentStream(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getSourceInfo() {
                return "javabin";
            }

            @Override
            public String getContentType() {
                return "application/javabin";
            }

            @Override
            public Long getSize() {
                return new Long(baos.size());
            }

            @Override
            public InputStream getStream() {
                return new ByteArrayInputStream(baos.getbuf(), 0, baos.size());
            }

            @Override
            public Reader getReader() {
                throw new RuntimeException("No reader available . this is a binarystream");
            }
        };
    }

    @Override
    public void write(SolrRequest request, OutputStream os) throws IOException {
        if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            new JavaBinUpdateRequestCodec().marshal(updateRequest, os);
        }
    }

    class BAOS
    extends ByteArrayOutputStream {
        BAOS() {
        }

        byte[] getbuf() {
            return this.buf;
        }
    }
}

