/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.analysis.MockTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;

public class MockTokenFilterFactory
extends TokenFilterFactory {
    final CharacterRunAutomaton filter;
    final boolean enablePositionIncrements;

    public MockTokenFilterFactory(Map<String, String> args) {
        super(args);
        String stopset = this.get(args, "stopset", Arrays.asList("english", "empty"), null, false);
        String stopregex = this.get(args, "stopregex");
        if (null != stopset) {
            if (null != stopregex) {
                throw new IllegalArgumentException("Parameters stopset and stopregex cannot both be specified.");
            }
            this.filter = "english".equalsIgnoreCase(stopset) ? MockTokenFilter.ENGLISH_STOPSET : MockTokenFilter.EMPTY_STOPSET;
        } else if (null != stopregex) {
            RegExp regex = new RegExp(stopregex);
            this.filter = new CharacterRunAutomaton(regex.toAutomaton());
        } else {
            throw new IllegalArgumentException("Configuration Error: either the 'stopset' or the 'stopregex' parameter must be specified.");
        }
        this.enablePositionIncrements = this.getBoolean(args, "enablePositionIncrements", true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public MockTokenFilter create(TokenStream stream) {
        return new MockTokenFilter(stream, this.filter);
    }
}

