/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.fess.suggest.converter;

import java.util.ArrayList;
import java.util.List;
import jp.sf.fess.suggest.converter.SuggestConverter;

public class SymbolConverter
implements SuggestConverter {
    protected List<String> symbolList = new ArrayList<String>();
    protected String symbolPrefix;
    protected String symbolSuffix;

    public SymbolConverter() {
        this("__ID", "__");
    }

    public SymbolConverter(String prefix, String suffix) {
        this.symbolPrefix = prefix;
        this.symbolSuffix = suffix;
    }

    @Override
    public String convert(String query) {
        String target = query;
        for (int i = 0; i < this.symbolList.size(); ++i) {
            target = target.replace(this.symbolList.get(i), this.symbolPrefix + Integer.valueOf(i) + this.symbolSuffix);
        }
        return target;
    }

    public void addSymbol(String[] symbols) {
        if (symbols == null || symbols.length == 0) {
            return;
        }
        for (String symbol : symbols) {
            this.symbolList.add(symbol);
        }
    }

    public void addSymbol(List<String> symbols) {
        if (symbols == null || symbols.size() == 0) {
            return;
        }
        for (String symbol : symbols) {
            this.symbolList.add(symbol);
        }
    }
}

