/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleFieldSource;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.queries.function.valuesource.IntFieldSource;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldCacheRangeFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TrieTokenizerFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieDateFieldSource;
import org.apache.solr.search.QParser;

public class TrieField
extends PrimitiveFieldType {
    public static final int DEFAULT_PRECISION_STEP = 8;
    protected int precisionStepArg = 8;
    protected int precisionStep;
    protected TrieTypes type;
    protected Object missingValue;
    static final DateField dateField = new DateField();
    static final String INT_PREFIX = new String(new char[]{'`'});
    static final String LONG_PREFIX = new String(new char[]{' '});

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        String t;
        super.init(schema, args);
        String p = args.remove("precisionStep");
        if (p != null) {
            this.precisionStepArg = Integer.parseInt(p);
        }
        this.precisionStep = this.precisionStepArg;
        if (this.precisionStep <= 0 || this.precisionStep >= 64) {
            this.precisionStep = Integer.MAX_VALUE;
        }
        if ((t = args.remove("type")) != null) {
            try {
                this.type = TrieTypes.valueOf(t.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid type specified in schema.xml for field: " + args.get("name"), (Throwable)e);
            }
        }
        CharFilterFactory[] filterFactories = new CharFilterFactory[]{};
        TokenFilterFactory[] tokenFilterFactories = new TokenFilterFactory[]{};
        this.analyzer = new TokenizerChain(filterFactories, new TrieTokenizerFactory(this.type, this.precisionStep), tokenFilterFactories);
        this.queryAnalyzer = new TokenizerChain(filterFactories, new TrieTokenizerFactory(this.type, Integer.MAX_VALUE), tokenFilterFactories);
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            return this.type == TrieTypes.DATE ? new Date(val.longValue()) : val;
        }
        BytesRef bytes = f.binaryValue();
        if (bytes == null) {
            return TrieField.badFieldString(f);
        }
        switch (this.type) {
            case INTEGER: {
                return TrieField.toInt(bytes.bytes, bytes.offset);
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat(TrieField.toInt(bytes.bytes, bytes.offset)));
            }
            case LONG: {
                return TrieField.toLong(bytes.bytes, bytes.offset);
            }
            case DOUBLE: {
                return Double.longBitsToDouble(TrieField.toLong(bytes.bytes, bytes.offset));
            }
            case DATE: {
                return new Date(TrieField.toLong(bytes.bytes, bytes.offset));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        field.checkSortability();
        Number missingValue = null;
        boolean sortMissingLast = field.sortMissingLast();
        boolean sortMissingFirst = field.sortMissingFirst();
        switch (this.type) {
            case INTEGER: {
                if (sortMissingLast) {
                    missingValue = top ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                } else if (sortMissingFirst) {
                    missingValue = top ? Integer.MAX_VALUE : Integer.MIN_VALUE;
                }
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_INT_PARSER, top).setMissingValue((Object)missingValue);
            }
            case FLOAT: {
                if (sortMissingLast) {
                    missingValue = Float.valueOf(top ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                } else if (sortMissingFirst) {
                    missingValue = Float.valueOf(top ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY);
                }
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_FLOAT_PARSER, top).setMissingValue((Object)missingValue);
            }
            case LONG: 
            case DATE: {
                if (sortMissingLast) {
                    missingValue = top ? Long.MIN_VALUE : Long.MAX_VALUE;
                } else if (sortMissingFirst) {
                    missingValue = top ? Long.MAX_VALUE : Long.MIN_VALUE;
                }
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_LONG_PARSER, top).setMissingValue((Object)missingValue);
            }
            case DOUBLE: {
                if (sortMissingLast) {
                    missingValue = top ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                } else if (sortMissingFirst) {
                    missingValue = top ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
                }
                return new SortField(field.getName(), (FieldCache.Parser)FieldCache.NUMERIC_UTILS_DOUBLE_PARSER, top).setMissingValue((Object)missingValue);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        switch (this.type) {
            case INTEGER: {
                return new IntFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_INT_PARSER);
            }
            case FLOAT: {
                return new FloatFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_FLOAT_PARSER);
            }
            case DATE: {
                return new TrieDateFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_LONG_PARSER);
            }
            case LONG: {
                return new LongFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_LONG_PARSER);
            }
            case DOUBLE: {
                return new DoubleFieldSource(field.getName(), FieldCache.NUMERIC_UTILS_DOUBLE_PARSER);
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + field.name);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeVal(name, this.toObject(f));
    }

    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public boolean multiValuedFieldCache() {
        return false;
    }

    public int getPrecisionStep() {
        return this.precisionStepArg;
    }

    public TrieTypes getType() {
        return this.type;
    }

    @Override
    public FieldType.NumericType getNumericType() {
        switch (this.type) {
            case INTEGER: {
                return FieldType.NumericType.INT;
            }
            case LONG: 
            case DATE: {
                return FieldType.NumericType.LONG;
            }
            case FLOAT: {
                return FieldType.NumericType.FLOAT;
            }
            case DOUBLE: {
                return FieldType.NumericType.DOUBLE;
            }
        }
        throw new AssertionError();
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        if (field.multiValued() && field.hasDocValues() && !field.indexed()) {
            return super.getRangeQuery(parser, field, min, max, minInclusive, maxInclusive);
        }
        int ps = this.precisionStep;
        NumericRangeQuery query = null;
        boolean matchOnly = field.hasDocValues() && !field.indexed();
        switch (this.type) {
            case INTEGER: {
                if (matchOnly) {
                    query = new ConstantScoreQuery((Filter)FieldCacheRangeFilter.newIntRange((String)field.getName(), (Integer)(min == null ? null : Integer.valueOf(Integer.parseInt(min))), (Integer)(max == null ? null : Integer.valueOf(Integer.parseInt(max))), (boolean)minInclusive, (boolean)maxInclusive));
                    break;
                }
                query = NumericRangeQuery.newIntRange((String)field.getName(), (int)ps, (Integer)(min == null ? null : Integer.valueOf(Integer.parseInt(min))), (Integer)(max == null ? null : Integer.valueOf(Integer.parseInt(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case FLOAT: {
                if (matchOnly) {
                    query = new ConstantScoreQuery((Filter)FieldCacheRangeFilter.newFloatRange((String)field.getName(), (Float)(min == null ? null : Float.valueOf(Float.parseFloat(min))), (Float)(max == null ? null : Float.valueOf(Float.parseFloat(max))), (boolean)minInclusive, (boolean)maxInclusive));
                    break;
                }
                query = NumericRangeQuery.newFloatRange((String)field.getName(), (int)ps, (Float)(min == null ? null : Float.valueOf(Float.parseFloat(min))), (Float)(max == null ? null : Float.valueOf(Float.parseFloat(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case LONG: {
                if (matchOnly) {
                    query = new ConstantScoreQuery((Filter)FieldCacheRangeFilter.newLongRange((String)field.getName(), (Long)(min == null ? null : Long.valueOf(Long.parseLong(min))), (Long)(max == null ? null : Long.valueOf(Long.parseLong(max))), (boolean)minInclusive, (boolean)maxInclusive));
                    break;
                }
                query = NumericRangeQuery.newLongRange((String)field.getName(), (int)ps, (Long)(min == null ? null : Long.valueOf(Long.parseLong(min))), (Long)(max == null ? null : Long.valueOf(Long.parseLong(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case DOUBLE: {
                if (matchOnly) {
                    query = new ConstantScoreQuery((Filter)FieldCacheRangeFilter.newDoubleRange((String)field.getName(), (Double)(min == null ? null : Double.valueOf(Double.parseDouble(min))), (Double)(max == null ? null : Double.valueOf(Double.parseDouble(max))), (boolean)minInclusive, (boolean)maxInclusive));
                    break;
                }
                query = NumericRangeQuery.newDoubleRange((String)field.getName(), (int)ps, (Double)(min == null ? null : Double.valueOf(Double.parseDouble(min))), (Double)(max == null ? null : Double.valueOf(Double.parseDouble(max))), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            case DATE: {
                if (matchOnly) {
                    query = new ConstantScoreQuery((Filter)FieldCacheRangeFilter.newLongRange((String)field.getName(), (Long)(min == null ? null : Long.valueOf(dateField.parseMath(null, min).getTime())), max == null ? null : Long.valueOf(dateField.parseMath(null, max).getTime()), (boolean)minInclusive, (boolean)maxInclusive));
                    break;
                }
                query = NumericRangeQuery.newLongRange((String)field.getName(), (int)ps, (Long)(min == null ? null : Long.valueOf(dateField.parseMath(null, min).getTime())), max == null ? null : Long.valueOf(dateField.parseMath(null, max).getTime()), (boolean)minInclusive, (boolean)maxInclusive);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field");
            }
        }
        return query;
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        if (!field.indexed() && field.hasDocValues()) {
            return this.getRangeQuery(parser, field, externalVal, externalVal, true, true);
        }
        return super.getFieldQuery(parser, field, externalVal);
    }

    @Deprecated
    static int toInt(byte[] arr, int offset) {
        return arr[offset] << 24 | (arr[offset + 1] & 0xFF) << 16 | (arr[offset + 2] & 0xFF) << 8 | arr[offset + 3] & 0xFF;
    }

    @Deprecated
    static long toLong(byte[] arr, int offset) {
        int high = arr[offset] << 24 | (arr[offset + 1] & 0xFF) << 16 | (arr[offset + 2] & 0xFF) << 8 | arr[offset + 3] & 0xFF;
        int low = arr[offset + 4] << 24 | (arr[offset + 5] & 0xFF) << 16 | (arr[offset + 6] & 0xFF) << 8 | arr[offset + 7] & 0xFF;
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    @Override
    public String storedToReadable(IndexableField f) {
        return this.toExternal(f);
    }

    @Override
    public String readableToIndexed(String val) {
        BytesRef bytes = new BytesRef(11);
        this.readableToIndexed(val, bytes);
        return bytes.utf8ToString();
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRef result) {
        String s = ((Object)val).toString();
        switch (this.type) {
            case INTEGER: {
                NumericUtils.intToPrefixCodedBytes((int)Integer.parseInt(s), (int)0, (BytesRef)result);
                break;
            }
            case FLOAT: {
                NumericUtils.intToPrefixCodedBytes((int)NumericUtils.floatToSortableInt((float)Float.parseFloat(s)), (int)0, (BytesRef)result);
                break;
            }
            case LONG: {
                NumericUtils.longToPrefixCodedBytes((long)Long.parseLong(s), (int)0, (BytesRef)result);
                break;
            }
            case DOUBLE: {
                NumericUtils.longToPrefixCodedBytes((long)NumericUtils.doubleToSortableLong((double)Double.parseDouble(s)), (int)0, (BytesRef)result);
                break;
            }
            case DATE: {
                NumericUtils.longToPrefixCodedBytes((long)dateField.parseMath(null, s).getTime(), (int)0, (BytesRef)result);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public String toInternal(String val) {
        return this.readableToIndexed(val);
    }

    static String badFieldString(IndexableField f) {
        String s = f.stringValue();
        return "ERROR:SCHEMA-INDEX-MISMATCH,stringValue=" + s;
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.type == TrieTypes.DATE ? dateField.toExternal((Date)this.toObject(f)) : this.toObject(f).toString();
    }

    @Override
    public String indexedToReadable(String _indexedForm) {
        BytesRef indexedForm = new BytesRef((CharSequence)_indexedForm);
        switch (this.type) {
            case INTEGER: {
                return Integer.toString(NumericUtils.prefixCodedToInt((BytesRef)indexedForm));
            }
            case FLOAT: {
                return Float.toString(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((BytesRef)indexedForm)));
            }
            case LONG: {
                return Long.toString(NumericUtils.prefixCodedToLong((BytesRef)indexedForm));
            }
            case DOUBLE: {
                return Double.toString(NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((BytesRef)indexedForm)));
            }
            case DATE: {
                return dateField.toExternal(new Date(NumericUtils.prefixCodedToLong((BytesRef)indexedForm)));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public CharsRef indexedToReadable(BytesRef indexedForm, CharsRef charsRef) {
        String value;
        switch (this.type) {
            case INTEGER: {
                value = Integer.toString(NumericUtils.prefixCodedToInt((BytesRef)indexedForm));
                break;
            }
            case FLOAT: {
                value = Float.toString(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((BytesRef)indexedForm)));
                break;
            }
            case LONG: {
                value = Long.toString(NumericUtils.prefixCodedToLong((BytesRef)indexedForm));
                break;
            }
            case DOUBLE: {
                value = Double.toString(NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((BytesRef)indexedForm)));
                break;
            }
            case DATE: {
                value = dateField.toExternal(new Date(NumericUtils.prefixCodedToLong((BytesRef)indexedForm)));
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        charsRef.grow(value.length());
        charsRef.length = value.length();
        value.getChars(0, charsRef.length, charsRef.chars, 0);
        return charsRef;
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        switch (this.type) {
            case INTEGER: {
                return NumericUtils.prefixCodedToInt((BytesRef)term);
            }
            case FLOAT: {
                return Float.valueOf(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((BytesRef)term)));
            }
            case LONG: {
                return NumericUtils.prefixCodedToLong((BytesRef)term);
            }
            case DOUBLE: {
                return NumericUtils.sortableLongToDouble((long)NumericUtils.prefixCodedToLong((BytesRef)term));
            }
            case DATE: {
                return new Date(NumericUtils.prefixCodedToLong((BytesRef)term));
            }
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
    }

    @Override
    public String storedToIndexed(IndexableField f) {
        BytesRef bytes;
        block16: {
            block15: {
                bytes = new BytesRef(11);
                Number val = f.numericValue();
                if (val == null) break block15;
                switch (this.type) {
                    case INTEGER: {
                        NumericUtils.intToPrefixCodedBytes((int)val.intValue(), (int)0, (BytesRef)bytes);
                        break block16;
                    }
                    case FLOAT: {
                        NumericUtils.intToPrefixCodedBytes((int)NumericUtils.floatToSortableInt((float)val.floatValue()), (int)0, (BytesRef)bytes);
                        break block16;
                    }
                    case LONG: 
                    case DATE: {
                        NumericUtils.longToPrefixCodedBytes((long)val.longValue(), (int)0, (BytesRef)bytes);
                        break block16;
                    }
                    case DOUBLE: {
                        NumericUtils.longToPrefixCodedBytes((long)NumericUtils.doubleToSortableLong((double)val.doubleValue()), (int)0, (BytesRef)bytes);
                        break block16;
                    }
                    default: {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
                    }
                }
            }
            BytesRef bytesRef = f.binaryValue();
            if (bytesRef == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid field contents: " + f.name());
            }
            switch (this.type) {
                case INTEGER: {
                    NumericUtils.intToPrefixCodedBytes((int)TrieField.toInt(bytesRef.bytes, bytesRef.offset), (int)0, (BytesRef)bytes);
                    break;
                }
                case FLOAT: {
                    int v = TrieField.toInt(bytesRef.bytes, bytesRef.offset);
                    if (v < 0) {
                        v ^= Integer.MAX_VALUE;
                    }
                    NumericUtils.intToPrefixCodedBytes((int)v, (int)0, (BytesRef)bytes);
                    break;
                }
                case LONG: 
                case DATE: {
                    NumericUtils.longToPrefixCodedBytes((long)TrieField.toLong(bytesRef.bytes, bytesRef.offset), (int)0, (BytesRef)bytes);
                    break;
                }
                case DOUBLE: {
                    long v = TrieField.toLong(bytesRef.bytes, bytesRef.offset);
                    if (v < 0L) {
                        v ^= Long.MAX_VALUE;
                    }
                    NumericUtils.longToPrefixCodedBytes((long)v, (int)0, (BytesRef)bytes);
                    break;
                }
                default: {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + f.name());
                }
            }
        }
        return bytes.utf8ToString();
    }

    @Override
    public IndexableField createField(SchemaField field, Object value, float boost) {
        IntField f;
        boolean indexed = field.indexed();
        boolean stored = field.stored();
        boolean docValues = field.hasDocValues();
        if (!(indexed || stored || docValues)) {
            if (log.isTraceEnabled()) {
                log.trace("Ignoring unindexed/unstored field: " + field);
            }
            return null;
        }
        org.apache.lucene.document.FieldType ft = new org.apache.lucene.document.FieldType();
        ft.setStored(stored);
        ft.setTokenized(true);
        ft.setIndexed(indexed);
        ft.setOmitNorms(field.omitNorms());
        ft.setIndexOptions(this.getIndexOptions(field, value.toString()));
        switch (this.type) {
            case INTEGER: {
                ft.setNumericType(FieldType.NumericType.INT);
                break;
            }
            case FLOAT: {
                ft.setNumericType(FieldType.NumericType.FLOAT);
                break;
            }
            case LONG: {
                ft.setNumericType(FieldType.NumericType.LONG);
                break;
            }
            case DOUBLE: {
                ft.setNumericType(FieldType.NumericType.DOUBLE);
                break;
            }
            case DATE: {
                ft.setNumericType(FieldType.NumericType.LONG);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        ft.setNumericPrecisionStep(this.precisionStep);
        switch (this.type) {
            case INTEGER: {
                int i = value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
                f = new IntField(field.getName(), i, ft);
                break;
            }
            case FLOAT: {
                float fl = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
                f = new FloatField(field.getName(), fl, ft);
                break;
            }
            case LONG: {
                long l = value instanceof Number ? ((Number)value).longValue() : Long.parseLong(value.toString());
                f = new LongField(field.getName(), l, ft);
                break;
            }
            case DOUBLE: {
                double d = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
                f = new DoubleField(field.getName(), d, ft);
                break;
            }
            case DATE: {
                Date date = value instanceof Date ? (Date)value : dateField.parseMath(null, value.toString());
                f = new LongField(field.getName(), date.getTime(), ft);
                break;
            }
            default: {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)this.type));
            }
        }
        f.setBoost(boost);
        return f;
    }

    @Override
    public List<IndexableField> createFields(SchemaField sf, Object value, float boost) {
        if (sf.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            IndexableField field = this.createField(sf, value, boost);
            fields.add(field);
            if (sf.multiValued()) {
                BytesRef bytes = new BytesRef();
                this.readableToIndexed(value.toString(), bytes);
                fields.add((IndexableField)new SortedSetDocValuesField(sf.getName(), bytes));
            } else {
                long bits;
                if (field.numericValue() instanceof Integer || field.numericValue() instanceof Long) {
                    bits = field.numericValue().longValue();
                } else if (field.numericValue() instanceof Float) {
                    bits = Float.floatToIntBits(field.numericValue().floatValue());
                } else {
                    assert (field.numericValue() instanceof Double);
                    bits = Double.doubleToLongBits(field.numericValue().doubleValue());
                }
                fields.add((IndexableField)new NumericDocValuesField(sf.getName(), bits));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(sf, value, boost));
    }

    public static String getMainValuePrefix(FieldType ft) {
        if (ft instanceof TrieDateField) {
            ft = ((TrieDateField)ft).wrappedField;
        }
        if (ft instanceof TrieField) {
            TrieField trie = (TrieField)ft;
            if (trie.precisionStep == Integer.MAX_VALUE) {
                return null;
            }
            switch (trie.type) {
                case INTEGER: 
                case FLOAT: {
                    return INT_PREFIX;
                }
                case LONG: 
                case DOUBLE: 
                case DATE: {
                    return LONG_PREFIX;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type for trie field: " + (Object)((Object)trie.type));
        }
        return null;
    }

    @Override
    public void checkSchemaField(SchemaField field) {
        if (field.hasDocValues() && !field.multiValued() && !field.isRequired() && field.getDefaultValue() == null) {
            throw new IllegalStateException("Field " + this + " has single-valued doc values enabled, but has no default value and is not required");
        }
    }

    public static enum TrieTypes {
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        DATE;

    }
}

