/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.logging.log4j;

import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.logging.CircularList;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.LoggerInfo;
import org.apache.solr.logging.log4j.EventAppender;
import org.apache.solr.logging.log4j.Log4jInfo;

public class Log4jWatcher
extends LogWatcher<LoggingEvent> {
    final String name;
    AppenderSkeleton appender = null;

    public Log4jWatcher(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return "Log4j (" + this.name + ")";
    }

    @Override
    public List<String> getAllLevels() {
        return Arrays.asList(Level.ALL.toString(), Level.TRACE.toString(), Level.DEBUG.toString(), Level.INFO.toString(), Level.WARN.toString(), Level.ERROR.toString(), Level.FATAL.toString(), Level.OFF.toString());
    }

    @Override
    public void setLogLevel(String category, String level) {
        Logger log = "root".equals(category) ? LogManager.getRootLogger() : Logger.getLogger((String)category);
        if (level == null || "unset".equals(level) || "null".equals(level)) {
            log.setLevel(null);
        } else {
            log.setLevel(Level.toLevel((String)level));
        }
    }

    @Override
    public Collection<LoggerInfo> getAllLoggers() {
        Logger root = LogManager.getRootLogger();
        HashMap<String, Log4jInfo> map = new HashMap<String, Log4jInfo>();
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            int dot;
            Logger logger = (Logger)loggers.nextElement();
            String name = logger.getName();
            if (logger == root) continue;
            map.put(name, new Log4jInfo(name, logger));
            while ((dot = name.lastIndexOf(".")) >= 0) {
                if (map.containsKey(name = name.substring(0, dot))) continue;
                map.put(name, new Log4jInfo(name, null));
            }
        }
        map.put("root", new Log4jInfo("root", root));
        return map.values();
    }

    @Override
    public void setThreshold(String level) {
        if (this.appender == null) {
            throw new IllegalStateException("Must have an appender");
        }
        this.appender.setThreshold((Priority)Level.toLevel((String)level));
    }

    @Override
    public String getThreshold() {
        if (this.appender == null) {
            throw new IllegalStateException("Must have an appender");
        }
        return this.appender.getThreshold().toString();
    }

    @Override
    public void registerListener(ListenerConfig cfg) {
        if (this.history != null) {
            throw new IllegalStateException("History already registered");
        }
        this.history = new CircularList(cfg.size);
        this.appender = new EventAppender(this);
        if (cfg.threshold != null) {
            this.appender.setThreshold((Priority)Level.toLevel((String)cfg.threshold));
        } else {
            this.appender.setThreshold((Priority)Level.WARN);
        }
        Logger log = LogManager.getRootLogger();
        log.addAppender((Appender)this.appender);
    }

    @Override
    public long getTimestamp(LoggingEvent event) {
        return event.timeStamp;
    }

    @Override
    public SolrDocument toSolrDocument(LoggingEvent event) {
        SolrDocument doc = new SolrDocument();
        doc.setField("time", (Object)new Date(event.getTimeStamp()));
        doc.setField("level", (Object)event.getLevel().toString());
        doc.setField("logger", (Object)event.getLogger().getName());
        doc.setField("message", (Object)event.getMessage().toString());
        ThrowableInformation t = event.getThrowableInformation();
        if (t != null) {
            doc.setField("trace", (Object)Throwables.getStackTraceAsString((Throwable)t.getThrowable()));
        }
        return doc;
    }
}

