/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.cloud.SolrZkServerProps;
import org.apache.solr.common.SolrException;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrZkServer {
    static Logger log = LoggerFactory.getLogger(SolrZkServer.class);
    String zkRun;
    String zkHost;
    String solrPort;
    Properties props;
    SolrZkServerProps zkProps;
    private Thread zkThread;
    private String dataHome;
    private String confHome;

    public SolrZkServer(String zkRun, String zkHost, String dataHome, String confHome, String solrPort) {
        this.zkRun = zkRun;
        this.zkHost = zkHost;
        this.dataHome = dataHome;
        this.confHome = confHome;
        this.solrPort = solrPort;
    }

    public String getClientString() {
        if (this.zkHost != null) {
            return this.zkHost;
        }
        if (this.zkProps == null) {
            return null;
        }
        if (this.zkRun == null) {
            return null;
        }
        return "localhost:" + this.zkProps.getClientPortAddress().getPort();
    }

    public void parseConfig() {
        block6: {
            if (this.zkProps == null) {
                this.zkProps = new SolrZkServerProps();
                this.zkProps.setDataDir(this.dataHome);
                this.zkProps.zkRun = this.zkRun;
                this.zkProps.solrPort = this.solrPort;
            }
            try {
                this.props = SolrZkServerProps.getProperties(this.confHome + '/' + "zoo.cfg");
                SolrZkServerProps.injectServers(this.props, this.zkRun, this.zkHost);
                this.zkProps.parseProperties(this.props);
                if (this.zkProps.getClientPortAddress() == null) {
                    this.zkProps.setClientPort(Integer.parseInt(this.solrPort) + 1000);
                }
            }
            catch (QuorumPeerConfig.ConfigException e) {
                if (this.zkRun != null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
            catch (IOException e) {
                if (this.zkRun == null) break block6;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
    }

    public Map<Long, QuorumPeer.QuorumServer> getServers() {
        return this.zkProps.getServers();
    }

    public void start() {
        if (this.zkRun == null) {
            return;
        }
        this.zkThread = new Thread(){

            @Override
            public void run() {
                try {
                    if (SolrZkServer.this.zkProps.getServers().size() > 1) {
                        QuorumPeerMain zkServer = new QuorumPeerMain();
                        zkServer.runFromConfig((QuorumPeerConfig)SolrZkServer.this.zkProps);
                    } else {
                        ServerConfig sc = new ServerConfig();
                        sc.readFrom((QuorumPeerConfig)SolrZkServer.this.zkProps);
                        ZooKeeperServerMain zkServer = new ZooKeeperServerMain();
                        zkServer.runFromConfig(sc);
                    }
                    log.info("ZooKeeper Server exited.");
                }
                catch (Throwable e) {
                    log.error("ZooKeeper Server ERROR", e);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e);
                }
            }
        };
        if (this.zkProps.getServers().size() > 1) {
            log.info("STARTING EMBEDDED ENSEMBLE ZOOKEEPER SERVER at port " + this.zkProps.getClientPortAddress().getPort());
        } else {
            log.info("STARTING EMBEDDED STANDALONE ZOOKEEPER SERVER at port " + this.zkProps.getClientPortAddress().getPort());
        }
        this.zkThread.setDaemon(true);
        this.zkThread.start();
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            log.error("STARTING ZOOKEEPER", (Throwable)e);
        }
    }

    public void stop() {
        if (this.zkRun == null) {
            return;
        }
        this.zkThread.interrupt();
    }
}

