/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.color.ColorSpaceLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;

public class PDLab
extends PDColorSpace {
    public static final String NAME = "Lab";
    private COSArray array;
    private COSDictionary dictionary;

    public PDLab() {
        this.array = new COSArray();
        this.dictionary = new COSDictionary();
        this.array.add(COSName.LAB);
        this.array.add(this.dictionary);
    }

    public PDLab(COSArray lab) {
        this.array = lab;
        this.dictionary = (COSDictionary)this.array.getObject(1);
    }

    public String getName() {
        return NAME;
    }

    public COSBase getCOSObject() {
        return this.array;
    }

    protected ColorSpace createColorSpace() throws IOException {
        return new ColorSpaceLab(this.getWhitepoint(), this.getBlackPoint(), this.getARange(), this.getBRange());
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        int[] nBits = new int[]{bpc, bpc, bpc};
        return new ComponentColorModel(this.getJavaColorSpace(), nBits, false, false, 1, 0);
    }

    public int getNumberOfComponents() throws IOException {
        return 3;
    }

    public PDTristimulus getWhitepoint() {
        COSArray wp = (COSArray)this.dictionary.getDictionaryObject(COSName.WHITE_POINT);
        if (wp == null) {
            wp = new COSArray();
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            this.dictionary.setItem(COSName.WHITE_POINT, (COSBase)wp);
        }
        return new PDTristimulus(wp);
    }

    public void setWhitepoint(PDTristimulus wp) {
        COSBase wpArray = wp.getCOSObject();
        if (wpArray != null) {
            this.dictionary.setItem(COSName.WHITE_POINT, wpArray);
        }
    }

    public PDTristimulus getBlackPoint() {
        COSArray bp = (COSArray)this.dictionary.getDictionaryObject(COSName.BLACK_POINT);
        if (bp == null) {
            bp = new COSArray();
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            this.dictionary.setItem(COSName.BLACK_POINT, (COSBase)bp);
        }
        return new PDTristimulus(bp);
    }

    public void setBlackPoint(PDTristimulus bp) {
        COSBase bpArray = null;
        if (bp != null) {
            bpArray = bp.getCOSObject();
        }
        this.dictionary.setItem(COSName.BLACK_POINT, bpArray);
    }

    private COSArray getRangeArray() {
        COSArray range = (COSArray)this.dictionary.getDictionaryObject(COSName.RANGE);
        if (range == null) {
            range = new COSArray();
            this.dictionary.setItem(COSName.RANGE, (COSBase)this.array);
            range.add(new COSFloat(-100.0f));
            range.add(new COSFloat(100.0f));
            range.add(new COSFloat(-100.0f));
            range.add(new COSFloat(100.0f));
        }
        return range;
    }

    public PDRange getARange() {
        COSArray range = this.getRangeArray();
        return new PDRange(range, 0);
    }

    public void setARange(PDRange range) {
        COSArray rangeArray = null;
        if (range == null) {
            rangeArray = this.getRangeArray();
            rangeArray.set(0, new COSFloat(-100.0f));
            rangeArray.set(1, new COSFloat(100.0f));
        } else {
            rangeArray = range.getCOSArray();
        }
        this.dictionary.setItem(COSName.RANGE, (COSBase)rangeArray);
    }

    public PDRange getBRange() {
        COSArray range = this.getRangeArray();
        return new PDRange(range, 1);
    }

    public void setBRange(PDRange range) {
        COSArray rangeArray = null;
        if (range == null) {
            rangeArray = this.getRangeArray();
            rangeArray.set(2, new COSFloat(-100.0f));
            rangeArray.set(3, new COSFloat(100.0f));
        } else {
            rangeArray = range.getCOSArray();
        }
        this.dictionary.setItem(COSName.RANGE, (COSBase)rangeArray);
    }
}

