/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.core.util;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.codelibs.core.exception.UnsupportedEncodingRuntimeException;

public class StringUtil
extends org.seasar.util.lang.StringUtil {
    protected StringUtil() {
    }

    public static String newString(byte[] bytes, String charsetName) {
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingRuntimeException(e);
        }
    }

    public static byte[] getBytes(String str, String charsetName) {
        try {
            return str.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingRuntimeException(e);
        }
    }

    public static boolean isEmpty(Collection<String> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (String text : c) {
            if (!StringUtil.isNotEmpty((String)text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(Collection<String> c) {
        return !StringUtil.isEmpty(c);
    }

    public static boolean isBlank(Collection<String> c) {
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (String text : c) {
            if (!StringUtil.isNotBlank((String)text)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(Collection<String> c) {
        return !StringUtil.isBlank(c);
    }
}

