/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.IOException;
import java.io.OutputStream;
import jp.gr.java_conf.dangan.util.lha.PostLzssEncoder;

public class PostLz5Encoder
implements PostLzssEncoder {
    private static final int DictionarySize = 4096;
    private static final int MaxMatch = 18;
    private static final int Threshold = 3;
    private OutputStream out;
    private byte[] buf;
    private int index;
    private int flagIndex;
    private int flagBit;
    private int position;

    private PostLz5Encoder() {
    }

    public PostLz5Encoder(OutputStream outputStream) {
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        this.out = outputStream;
        this.position = 0;
        this.buf = new byte[1024];
        this.index = 0;
        this.flagIndex = 0;
        this.flagBit = 256;
    }

    public void writeCode(int n) throws IOException {
        if (this.flagBit == 256) {
            if (this.buf.length - 17 < this.index) {
                this.out.write(this.buf, 0, this.index);
                this.index = 0;
            }
            this.flagBit = 1;
            this.flagIndex = this.index++;
            this.buf[this.flagIndex] = 0;
        }
        if (n < 256) {
            int n2 = this.flagIndex;
            this.buf[n2] = (byte)(this.buf[n2] | this.flagBit);
            this.buf[this.index++] = (byte)n;
            ++this.position;
        } else {
            this.buf[this.index++] = (byte)n;
        }
        this.flagBit <<= 1;
    }

    public void writeOffset(int n) {
        int n2 = this.position - n - 1 - 18 & 0xFFF;
        int n3 = this.buf[--this.index] & 0xF;
        this.buf[this.index++] = (byte)n2;
        this.buf[this.index++] = (byte)(n2 >> 4 & 0xF0 | n3);
        this.position += n3 + 3;
    }

    public void flush() throws IOException {
        if (this.flagBit == 256) {
            this.out.write(this.buf, 0, this.index);
            this.out.flush();
            this.index = 0;
            this.flagBit = 1;
            this.flagIndex = this.index++;
            this.buf[this.flagIndex] = 0;
        } else {
            this.out.write(this.buf, 0, this.flagIndex);
            this.out.flush();
            System.arraycopy(this.buf, this.flagIndex, this.buf, 0, this.index - this.flagIndex);
            this.index -= this.flagIndex;
            this.flagIndex = 0;
        }
    }

    public void close() throws IOException {
        this.out.write(this.buf, 0, this.index);
        this.out.close();
        this.out = null;
        this.buf = null;
    }

    public int getDictionarySize() {
        return 4096;
    }

    public int getMaxMatch() {
        return 18;
    }

    public int getThreshold() {
        return 3;
    }
}

