/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.dangan.util.lha;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;

public class CompressMethod {
    public static final String LH0 = "-lh0-";
    public static final String LH1 = "-lh1-";
    public static final String LH2 = "-lh2-";
    public static final String LH3 = "-lh3-";
    public static final String LH4 = "-lh4-";
    public static final String LH5 = "-lh5-";
    public static final String LH6 = "-lh6-";
    public static final String LH7 = "-lh7-";
    public static final String LHD = "-lhd-";
    public static final String LZS = "-lzs-";
    public static final String LZ4 = "-lz4-";
    public static final String LZ5 = "-lz5-";

    private CompressMethod() {
    }

    public static int toDictionarySize(String string) {
        if (LZS.equalsIgnoreCase(string)) {
            return 2048;
        }
        if (LZ5.equalsIgnoreCase(string)) {
            return 4096;
        }
        if (LH1.equalsIgnoreCase(string)) {
            return 4096;
        }
        if (LH2.equalsIgnoreCase(string)) {
            return 8192;
        }
        if (LH3.equalsIgnoreCase(string)) {
            return 8192;
        }
        if (LH4.equalsIgnoreCase(string)) {
            return 4096;
        }
        if (LH5.equalsIgnoreCase(string)) {
            return 8192;
        }
        if (LH6.equalsIgnoreCase(string)) {
            return 32768;
        }
        if (LH7.equalsIgnoreCase(string)) {
            return 65536;
        }
        if (LZ4.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(string + " means no compress.");
        }
        if (LH0.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(string + " means no compress.");
        }
        if (LHD.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(string + " means no compress.");
        }
        if (string == null) {
            throw new NullPointerException("method");
        }
        throw new IllegalArgumentException("Unknown compress method. " + string);
    }

    public static int toThreshold(String string) {
        if (LZS.equalsIgnoreCase(string)) {
            return 2;
        }
        if (LZ5.equalsIgnoreCase(string)) {
            return 3;
        }
        if (LH1.equalsIgnoreCase(string)) {
            return 3;
        }
        if (LH2.equalsIgnoreCase(string)) {
            return 3;
        }
        if (LH3.equalsIgnoreCase(string)) {
            return 3;
        }
        if (LH4.equalsIgnoreCase(string)) {
            return 3;
        }
        if (LH5.equalsIgnoreCase(string)) {
            return 3;
        }
        if (LH6.equalsIgnoreCase(string)) {
            return 3;
        }
        if (LH7.equalsIgnoreCase(string)) {
            return 3;
        }
        if (LZ4.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(string + " means no compress.");
        }
        if (LH0.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(string + " means no compress.");
        }
        if (LHD.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(string + " means no compress.");
        }
        if (string == null) {
            throw new NullPointerException("method");
        }
        throw new IllegalArgumentException("Unknown compress method. " + string);
    }

    public static int toMaxMatch(String string) {
        if (LZS.equalsIgnoreCase(string)) {
            return 17;
        }
        if (LZ5.equalsIgnoreCase(string)) {
            return 18;
        }
        if (LH1.equalsIgnoreCase(string)) {
            return 60;
        }
        if (LH2.equalsIgnoreCase(string)) {
            return 256;
        }
        if (LH3.equalsIgnoreCase(string)) {
            return 256;
        }
        if (LH4.equalsIgnoreCase(string)) {
            return 256;
        }
        if (LH5.equalsIgnoreCase(string)) {
            return 256;
        }
        if (LH6.equalsIgnoreCase(string)) {
            return 256;
        }
        if (LH7.equalsIgnoreCase(string)) {
            return 256;
        }
        if (LZ4.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(string + " means no compress.");
        }
        if (LH0.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(string + " means no compress.");
        }
        if (LHD.equalsIgnoreCase(string)) {
            throw new IllegalArgumentException(string + " means no compress.");
        }
        if (string == null) {
            throw new NullPointerException("method");
        }
        throw new IllegalArgumentException("Unknown compress method. " + string);
    }

    public static OutputStream connectEncoder(OutputStream outputStream, String string, Properties properties) {
        String string2;
        String string3 = "lha." + CompressMethod.getCore(string) + ".encoder";
        String string4 = properties.getProperty(string3);
        if (string4 == null) {
            string4 = LhaProperty.getProperty(string3);
        }
        if ((string2 = properties.getProperty("lha.packages")) == null) {
            string2 = LhaProperty.getProperty("lha.packages");
        }
        Hashtable<String, OutputStream> hashtable = new Hashtable<String, OutputStream>();
        hashtable.put("out", outputStream);
        return (OutputStream)LhaProperty.parse(string4, hashtable, string2);
    }

    public static InputStream connectDecoder(InputStream inputStream, String string, Properties properties, long l) {
        String string2;
        String string3 = "lha." + CompressMethod.getCore(string) + ".decoder";
        String string4 = properties.getProperty(string3);
        if (string4 == null) {
            string4 = LhaProperty.getProperty(string3);
        }
        if ((string2 = properties.getProperty("lha.packages")) == null) {
            string2 = LhaProperty.getProperty("lha.packages");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("in", inputStream);
        hashtable.put("length", new Long(l));
        return (InputStream)LhaProperty.parse(string4, hashtable, string2);
    }

    private static String getCore(String string) {
        if (string.startsWith("-") && string.endsWith("-")) {
            return string.substring(1, string.lastIndexOf(45)).toLowerCase();
        }
        throw new IllegalArgumentException("");
    }
}

